/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.genesis.impl;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;

public class Binding<T> {
    protected final Class<T> singletonClass;
    protected Class<? extends T> implementationClass;
    protected T instance;
    protected Map<Annotation, Binding<T>> annotationBindings;
    protected Map<Class<? extends Annotation>, Binding<T>> annotationClassBindings;

    public Binding(Class<T> singletonClass) {
        this.singletonClass = singletonClass;
    }

    public Binding<T> annotatedWith(Annotation annotation) {
        Binding<T> annotationBinding;
        if (this.annotationBindings == null) {
            this.annotationBindings = new HashMap<Annotation, Binding<T>>();
        }
        if ((annotationBinding = this.annotationBindings.get(annotation)) == null) {
            annotationBinding = new Binding<T>(this.singletonClass);
            this.annotationBindings.put(annotation, annotationBinding);
        }
        return annotationBinding;
    }

    public Binding<T> annotatedWith(Class<? extends Annotation> annotationClass) {
        Binding<T> annotationClassBinding;
        if (this.annotationClassBindings == null) {
            this.annotationClassBindings = new HashMap<Class<? extends Annotation>, Binding<T>>();
        }
        if ((annotationClassBinding = this.annotationClassBindings.get(annotationClass)) == null) {
            annotationClassBinding = new Binding<T>(this.singletonClass);
            this.annotationClassBindings.put(annotationClass, annotationClassBinding);
        }
        return annotationClassBinding;
    }

    public Binding<T> to(Class<? extends T> implementationClass) {
        this.implementationClass = implementationClass;
        this.instance = null;
        return this;
    }

    public void toInstance(T instance) {
        this.instance = instance;
        this.implementationClass = null;
    }

    public T getInstance() {
        return this.instance;
    }
}

