/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.habitat.command;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.iworkz.habitat.dao.GenericDao;
import org.iworkz.habitat.entity.EntityDefinition;
import org.iworkz.habitat.entity.EntityFieldDefinition;
import org.iworkz.habitat.sync.SynchronizedPropertyAccess;

public class CommandMetaData {
    private final EntityDefinition table;
    private String command;
    int totalFieldCount;
    ObjectMetaData[] objectMetaData;
    ObjectMetaData[] primaryKeyMetaData;
    ObjectMetaData[] versionMetaData;
    public final SynchronizedPropertyAccess<CommandMetaData, ObjectMetaData[]> objectMetaDataProperty;

    public CommandMetaData(EntityDefinition table) {
        this.table = table;
        this.objectMetaDataProperty = new SynchronizedPropertyAccess<CommandMetaData, ObjectMetaData[]>(this, this::getObjectMetaData, this::setObjectMetaData);
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public ObjectMetaData[] getObjectMetaData() {
        return this.objectMetaData;
    }

    public void setObjectMetaData(ObjectMetaData[] objectMetaData) {
        this.objectMetaData = objectMetaData;
    }

    public void setPropertyDescriptors(PropertyDescriptor[] resultSetFields, GenericDao.CommandCustomizer statementAdapter) {
        ArrayList<ObjectMetaData> primaryKeyList = new ArrayList<ObjectMetaData>();
        ArrayList<ObjectMetaData> versionList = new ArrayList<ObjectMetaData>();
        ObjectMetaData[] objectMetaDatas = new ObjectMetaData[resultSetFields.length];
        for (int i = 0; i < resultSetFields.length; ++i) {
            PropertyDescriptor propertyDescriptor = resultSetFields[i];
            objectMetaDatas[i] = new ObjectMetaData();
            objectMetaDatas[i].objectProperty = propertyDescriptor;
            objectMetaDatas[i].type = propertyDescriptor.getPropertyType();
            objectMetaDatas[i].writeMethod = propertyDescriptor.getWriteMethod();
            objectMetaDatas[i].readMethod = propertyDescriptor.getReadMethod();
            objectMetaDatas[i].databaseField = this.table.getDatabaseFieldForObjectFieldName(propertyDescriptor.getName());
            if (objectMetaDatas[i].databaseField.isPrimaryKeyField()) {
                primaryKeyList.add(objectMetaDatas[i]);
            }
            if (!objectMetaDatas[i].databaseField.isVersionField()) continue;
            versionList.add(objectMetaDatas[i]);
        }
        this.primaryKeyMetaData = new ObjectMetaData[primaryKeyList.size()];
        primaryKeyList.toArray(this.primaryKeyMetaData);
        this.versionMetaData = new ObjectMetaData[versionList.size()];
        versionList.toArray(this.versionMetaData);
        this.totalFieldCount = objectMetaDatas.length;
        if (statementAdapter != null && statementAdapter.customColumns() != null) {
            this.totalFieldCount += statementAdapter.customColumns().length;
        }
        this.setObjectMetaData(objectMetaDatas);
    }

    public int getTotalFieldCount() {
        return this.totalFieldCount;
    }

    public ObjectMetaData[] getPrimaryKeyMetaData() {
        return this.primaryKeyMetaData;
    }

    public ObjectMetaData[] getVersionMetaData() {
        return this.versionMetaData;
    }

    public static class ObjectMetaData {
        PropertyDescriptor objectProperty;
        Method writeMethod;
        Method readMethod;
        Class<?> type;
        EntityFieldDefinition databaseField;

        public int hashCode() {
            return this.objectProperty.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ObjectMetaData)) {
                return false;
            }
            return ((ObjectMetaData)obj).objectProperty.equals(obj);
        }

        public Class<?> getType() {
            return this.type;
        }

        public PropertyDescriptor getObjectProperty() {
            return this.objectProperty;
        }

        public Method getWriteMethod() {
            return this.writeMethod;
        }

        public Method getReadMethod() {
            return this.readMethod;
        }

        public EntityFieldDefinition getDatabaseField() {
            return this.databaseField;
        }
    }
}

