package org.iworkz.habitat.command;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;

import javax.inject.Singleton;

import org.iworkz.habitat.dao.FieldNavigator;
import org.iworkz.habitat.dao.GenericDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SelectExecutor extends AbstractExecutor {

    private static final Logger logger = LoggerFactory.getLogger(SelectExecutor.class);

    public <T> Collection<T> select(GenericDao dao, Class<T> objectClass, String selectSQL, Object... parameters) {

        String name = "select" + objectClass.getSimpleName() + selectSQL;

        CommandMetaData commandMetaData = dao.metaDataAccess.getValue(name);
        if (commandMetaData == null) {
            commandMetaData = dao.metaDataAccess.getOrCreateValue(name, (value) -> {
                value.setCommand(selectSQL);
            });
        }

        FieldNavigator ii = new FieldNavigator();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = dao.getConnection().prepareStatement(selectSQL.toString());
            for (int i = 0; i < parameters.length; i++) {
                this.commandHelper.setParameter(preparedStatement, i + 1, parameters[i]);
            }

            ResultSet rs = preparedStatement.executeQuery();

            if (!commandMetaData.objectMetaDataProperty.isDefined()) {
                commandMetaData.objectMetaDataProperty.create((object) -> {
                    object.setPropertyDescriptors(this.commandHelper.createPropertyDescriptorsForClass(dao.getEntityDefinition(), objectClass, null, rs), null);
                });
            }

            ArrayList<T> resultList = new ArrayList<T>();
            while (rs.next()) {
                ii.reset();
                T obj = this.reflectionHelper.createObject(objectClass);
                this.commandHelper.readFieldsFromResultSet(obj, commandMetaData.getObjectMetaData(), rs, ii);
                resultList.add(obj);
            }
            return resultList;
        } catch (Exception e) {
            logger.error(selectSQL);
            throw new RuntimeException("Can not read record from table " + dao.getEntityDefinition().getName(), e);
        } finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                } catch (Exception ex) {
                    logger.error("Prepared statement can not be closed", ex);
                }
            }
        }

    }

}
