package org.iworkz.habitat.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import javax.inject.Singleton;

import org.iworkz.habitat.entity.EntityDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DatabaseHelper {

    private static final Logger logger = LoggerFactory.getLogger(DatabaseHelper.class);

    public void dropTableIfExists(ConnectionProvider task, GenericDao dao) {
        dropTableIfExists(dao.getEntityDefinition(), task.get());
    }

    public void dropTableIfExists(GenericDao dao) {
        dropTableIfExists(dao.getEntityDefinition(), dao.getConnection());
    }

    public void dropTableIfExists(EntityDefinition table, Connection connection) {
        String sql = "DROP TABLE IF EXISTS " + table.getName() + ";";
        executeStatement(sql, connection);
    }

    public void createTable(ConnectionProvider task, GenericDao dao) {
        createTable(dao.getEntityDefinition(), task.get(), false);
    }

    public void createTable(GenericDao dao) {
        createTable(dao.getEntityDefinition(), dao.getConnection(), false);
    }

    public void createTableIfNotExists(Session session, GenericDao dao) {
        createTable(dao.getEntityDefinition(), session.getConnection(), true);
    }

    public void createTableIfNotExists(GenericDao dao) {
        createTable(dao.getEntityDefinition(), dao.getConnection(), true);
    }

    protected void createTable(EntityDefinition table, Connection connection, boolean onlyIfNotExists) {
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE ");
        if (onlyIfNotExists) {
            sql.append("IF NOT EXISTS ");
        }
        sql.append(table.getName() + "(");
        table.appendFieldDefinitionsSql(sql);
        table.appendPrimaryKeySqL(sql);
        sql.append(")");
        executeStatement(sql.toString(), connection);
    }

    public void executeStatement(Session session, String sqlCommand, GenericDao dao) {
        executeStatement(sqlCommand, session.getConnection());
    }

    public void executeStatement(String sqlCommand, GenericDao dao) {
        executeStatement(sqlCommand, dao.getConnection());
    }

    public void executeStatement(String createTableSQL, Connection connection) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(createTableSQL);
            preparedStatement.executeUpdate();
        } catch (SQLException e) {
            throw new RuntimeException("Can not execute statement", e);
        } finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                } catch (Exception ex) {
                    logger.error("Prepared statement can not be closed", ex);
                }
            }
        }
    }

}
