/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.common.helper;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.inject.Singleton;
import org.iworkz.common.reflection.PropertyInfo;

@Singleton
public class ReflectionHelper {
    protected static final Set<Class<?>> FINAL_IMMUTABLES = new HashSet();

    public <T> Field[] getAllFields(Class<T> objectClass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        this.addAllFields(fields, objectClass);
        return fields.toArray(new Field[fields.size()]);
    }

    protected <T> void addAllFields(List<Field> fields, Class<T> objectClass) {
        fields.addAll(Arrays.asList(objectClass.getDeclaredFields()));
        if (objectClass.getSuperclass() != null) {
            this.addAllFields(fields, objectClass.getSuperclass());
        }
    }

    public Method findFirstDeclaredMethod(Class<?> objectClass, Predicate<Method> predicate) {
        if (objectClass != null) {
            for (Class<?> currentClass = objectClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
                for (Method method : currentClass.getDeclaredMethods()) {
                    if (!predicate.test(method)) continue;
                    return method;
                }
            }
        }
        return null;
    }

    public <T> T createObject(Class<T> objectClass) {
        try {
            Constructor<T> defaultConstructor = objectClass.getConstructor(new Class[0]);
            T obj = defaultConstructor.newInstance(new Object[0]);
            return obj;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can not create instance for class '" + objectClass.getName() + "'", ex);
        }
    }

    public <T> Class<? extends T> findClassWithPostfix(ClassLoader classLoader, Class<T> type, String packagePostFix, String namePostFix) {
        String parentClassPart;
        String classPart;
        String packagePart;
        String className = type.getName();
        int lastDotIndex = className.lastIndexOf(46);
        if (lastDotIndex >= 0) {
            packagePart = className.substring(0, lastDotIndex);
            classPart = className.substring(lastDotIndex + 1);
        } else {
            packagePart = null;
            classPart = className;
        }
        int lastDollarIndex = classPart.lastIndexOf(36);
        if (lastDollarIndex >= 0) {
            parentClassPart = classPart.substring(0, lastDollarIndex);
            classPart = classPart.substring(lastDollarIndex + 1);
        } else {
            parentClassPart = null;
        }
        String customPackage = null;
        if (packagePart != null && packagePart.length() > 0) {
            customPackage = packagePostFix != null ? packagePart + "." + packagePostFix : packagePart;
        } else if (packagePostFix != null) {
            customPackage = packagePostFix;
        }
        String customClass = null;
        customClass = namePostFix != null ? classPart + namePostFix : classPart;
        if (parentClassPart != null) {
            customClass = parentClassPart + "$" + customClass;
        }
        String customClassName = null;
        customClassName = customPackage != null ? customPackage + "." + customClass : customClass;
        try {
            return this.load(classLoader, customClassName);
        }
        catch (ClassNotFoundException ex) {
        }
        catch (Exception ex) {
            throw new RuntimeException("Can not find class with postfix '" + customClassName + "'");
        }
        return null;
    }

    public <T> Class<T> load(ClassLoader classLoader, String className) throws ClassNotFoundException {
        return classLoader.loadClass(className);
    }

    public PropertyInfo createPropertyInfo(PropertyDescriptor pd) {
        Method writeMethod;
        Method readMethod = pd.getReadMethod();
        if (readMethod != null && (writeMethod = pd.getWriteMethod()) != null) {
            Class<?> valueClass = pd.getPropertyType();
            return this.createPropertyInfo(valueClass, readMethod, writeMethod);
        }
        return null;
    }

    public PropertyInfo createPropertyInfo(Class<?> valueClass, Method readMethod, Method writeMethod) {
        PropertyInfo propertyInfo = new PropertyInfo();
        propertyInfo.setReadMethod(readMethod);
        propertyInfo.setWriteMethod(writeMethod);
        if (valueClass.isArray()) {
            propertyInfo.setArray(true);
            propertyInfo.setComponentImmutable(this.isImmutable(valueClass.getComponentType()));
        } else if (Collection.class.isAssignableFrom(valueClass)) {
            propertyInfo.setCollection(true);
        } else if (Map.class.isAssignableFrom(valueClass)) {
            propertyInfo.setMap(true);
        } else if (this.isImmutable(valueClass)) {
            propertyInfo.setImmutable(this.isImmutable(valueClass));
        }
        return propertyInfo;
    }

    public boolean isImmutable(Class<?> valueClass) {
        if (valueClass.isPrimitive()) {
            return false;
        }
        if (valueClass.isEnum()) {
            return false;
        }
        return FINAL_IMMUTABLES.contains(valueClass);
    }

    static {
        FINAL_IMMUTABLES.add(String.class);
        FINAL_IMMUTABLES.add(Boolean.class);
        FINAL_IMMUTABLES.add(Character.class);
        FINAL_IMMUTABLES.add(Byte.class);
        FINAL_IMMUTABLES.add(Short.class);
        FINAL_IMMUTABLES.add(Integer.class);
        FINAL_IMMUTABLES.add(Long.class);
        FINAL_IMMUTABLES.add(Float.class);
        FINAL_IMMUTABLES.add(Double.class);
        FINAL_IMMUTABLES.add(Locale.class);
        FINAL_IMMUTABLES.add(UUID.class);
        FINAL_IMMUTABLES.add(BigInteger.class);
        FINAL_IMMUTABLES.add(BigDecimal.class);
    }
}

