/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.habitat.command;

import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Map;
import javax.inject.Singleton;
import org.iworkz.habitat.command.AbstractExecutor;
import org.iworkz.habitat.command.CommandMetaData;
import org.iworkz.habitat.dao.ConnectionProvider;
import org.iworkz.habitat.dao.FieldNavigator;
import org.iworkz.habitat.dao.GenericDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class InsertExecutor
extends AbstractExecutor {
    private static final Logger logger = LoggerFactory.getLogger(InsertExecutor.class);

    public <T> void executeInsert(ConnectionProvider task, GenericDao dao, GenericDao.CommandCustomizer statementAdapter, T obj) {
        Class<?> objectClass = obj.getClass();
        String name = "_insertObject" + obj.getClass().getName();
        CommandMetaData commandMetaData = dao.metaDataAccess.getValue(name);
        if (commandMetaData == null) {
            commandMetaData = dao.metaDataAccess.getOrCreateValue(name, value -> value.setCommand(this.commandBuilder.buildInsertCommand(dao.getEntityDefinition(), objectClass, statementAdapter)));
        }
        String sqlCommand = commandMetaData.getCommand();
        FieldNavigator ii = new FieldNavigator();
        Statement preparedStatement = null;
        try {
            if (!commandMetaData.objectMetaDataProperty.isDefined()) {
                commandMetaData.objectMetaDataProperty.create(object -> object.setPropertyDescriptors(this.commandHelper.createPropertyDescriptorsForClass(dao.getEntityDefinition(), objectClass, statementAdapter, null), statementAdapter));
            }
            Map<CommandMetaData.ObjectMetaData, Object> tempFieldValues = this.recordHelper.initializeNewRecord(obj, commandMetaData, dao.getIdGenerator());
            preparedStatement = this.getConnection(task, dao).prepareStatement(sqlCommand);
            this.commandHelper.writeRecordToPreparedStatement((PreparedStatement)preparedStatement, ii, obj, commandMetaData, tempFieldValues, statementAdapter, true);
            if (statementAdapter != null) {
                statementAdapter.customSetStatementParameter((PreparedStatement)preparedStatement, ii, obj);
            }
            preparedStatement.executeUpdate();
        }
        catch (Exception e) {
            logger.error(sqlCommand);
            throw new RuntimeException("Can not insert record in table " + dao.getEntityDefinition().getName(), e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception ex) {
                    logger.error("Prepared statement can not be closed", (Throwable)ex);
                }
            }
        }
    }

    public <T> T executeCreate(ConnectionProvider task, GenericDao dao, GenericDao.CommandCustomizer statementAdapter, T obj) {
        Class<?> objectClass = obj.getClass();
        String name = "_insertObject" + obj.getClass().getName();
        CommandMetaData commandMetaData = dao.metaDataAccess.getValue(name);
        if (commandMetaData == null) {
            commandMetaData = dao.metaDataAccess.getOrCreateValue(name, value -> value.setCommand(this.commandBuilder.buildInsertCommand(dao.getEntityDefinition(), objectClass, statementAdapter)));
        }
        String sqlCommand = commandMetaData.getCommand();
        FieldNavigator ii = new FieldNavigator();
        Statement preparedStatement = null;
        try {
            if (!commandMetaData.objectMetaDataProperty.isDefined()) {
                commandMetaData.objectMetaDataProperty.create(object -> object.setPropertyDescriptors(this.commandHelper.createPropertyDescriptorsForClass(dao.getEntityDefinition(), objectClass, statementAdapter, null), statementAdapter));
            }
            Map<CommandMetaData.ObjectMetaData, Object> tempFieldValues = this.recordHelper.initializeNewRecord(obj, commandMetaData, dao.getIdGenerator());
            preparedStatement = this.getConnection(task, dao).prepareStatement(sqlCommand);
            this.commandHelper.writeRecordToPreparedStatement((PreparedStatement)preparedStatement, ii, obj, commandMetaData, tempFieldValues, statementAdapter, true);
            if (statementAdapter != null) {
                statementAdapter.customSetStatementParameter((PreparedStatement)preparedStatement, ii, obj);
            }
            preparedStatement.executeUpdate();
            T persistentObject = this.cloneBean(obj);
            this.commandHelper.applyTempFieldValues(persistentObject, tempFieldValues);
            T t = persistentObject;
            return t;
        }
        catch (Exception e) {
            logger.error(sqlCommand);
            throw new RuntimeException("Can not insert record in table " + dao.getEntityDefinition().getName(), e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception ex) {
                    logger.error("Prepared statement can not be closed", (Throwable)ex);
                }
            }
        }
    }
}

