/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.habitat.helper;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Singleton;
import org.iworkz.habitat.command.CommandMetaData;
import org.iworkz.habitat.dao.IdGenerator;
import org.iworkz.habitat.entity.FieldValueStrategy;

@Singleton
public class RecordHelper {
    public Map<CommandMetaData.ObjectMetaData, Object> initializeNewRecord(Object record, CommandMetaData commandMetaData, IdGenerator<?> idGenerator) throws Exception {
        LinkedHashMap<CommandMetaData.ObjectMetaData, Object> initializedFieldValues = new LinkedHashMap<CommandMetaData.ObjectMetaData, Object>();
        this.initializePrimaryKeyOfRecord(record, commandMetaData, initializedFieldValues, idGenerator);
        this.initializeVersionOfRecord(record, commandMetaData, initializedFieldValues);
        return initializedFieldValues;
    }

    protected void initializePrimaryKeyOfRecord(Object record, CommandMetaData commandMetaData, Map<CommandMetaData.ObjectMetaData, Object> initializedFieldValues, IdGenerator<?> idGenerator) throws Exception {
        for (CommandMetaData.ObjectMetaData f : commandMetaData.getPrimaryKeyMetaData()) {
            if (f.getDatabaseField().getValueStrategy() != FieldValueStrategy.GENERATED) continue;
            if (f.getType() == String.class) {
                String nextID = (String)this.generateId(idGenerator);
                initializedFieldValues.put(f, nextID);
                continue;
            }
            throw new RuntimeException("Unsupported type for primary key field: " + f.getType());
        }
    }

    protected Object generateId(IdGenerator<?> idGenerator) {
        return idGenerator.nextId(null);
    }

    protected void initializeVersionOfRecord(Object record, CommandMetaData commandMetaData, Map<CommandMetaData.ObjectMetaData, Object> initializedFieldValues) throws Exception {
        for (CommandMetaData.ObjectMetaData f : commandMetaData.getVersionMetaData()) {
            if (f.getType() != Integer.class) {
                throw new RuntimeException("Unsupported type for version field" + f.getType());
            }
            Integer initialVersion = 1;
            initializedFieldValues.put(f, initialVersion);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<CommandMetaData.ObjectMetaData, Object> createUpdatedVersionInfo(Object record, CommandMetaData commandMetaData) throws Exception {
        LinkedHashMap<CommandMetaData.ObjectMetaData, Integer> updatedVersionInfo = null;
        if (commandMetaData == null) throw new RuntimeException("Command metadata is null");
        if (commandMetaData.getVersionMetaData() == null) throw new RuntimeException("Version metadata is null");
        for (CommandMetaData.ObjectMetaData f : commandMetaData.getVersionMetaData()) {
            Object currentVersion = f.getReadMethod().invoke(record, new Object[0]);
            if (currentVersion == null) {
                throw new RuntimeException("The version field must not be null (version field name in database = '" + f.getDatabaseField().getName() + "')");
            }
            if (!(currentVersion instanceof Integer)) throw new RuntimeException("Unsupported type for version field");
            Integer newVersion = (Integer)currentVersion + 1;
            if (updatedVersionInfo != null) continue;
            updatedVersionInfo = new LinkedHashMap<CommandMetaData.ObjectMetaData, Integer>();
            updatedVersionInfo.put(f, newVersion);
        }
        return updatedVersionInfo;
    }
}

