package org.iworkz.habitat.entity;

import org.iworkz.habitat.dao.FieldType;


public class EntityFieldDefinition {
	
	private final String name;
	final String objectFieldName;
	private final FieldType type;
	private Integer constraint1;
	private Integer constraint2;
	boolean notNull;
	boolean versionField;
	boolean primaryKeyField;
	private final FieldValueStrategy valueStrategy;
	
	public EntityFieldDefinition(String name, String objectFieldName, FieldType type, FieldValueStrategy fieldValueStrategy, boolean notNull) {
		this.name = name;
		this.objectFieldName = objectFieldName;
		this.type = type;
		this.valueStrategy = fieldValueStrategy;
		this.notNull = notNull;
	}
	
	public EntityFieldDefinition(String name, String objectFieldName, FieldType type, FieldValueStrategy fieldValueStrategy) {
		this(name,objectFieldName,type,fieldValueStrategy,false);
	}
	
	public EntityFieldDefinition(String name, String objectFieldName, FieldType type, FieldValueStrategy fieldValueStrategy, int constraint1, boolean notNull) {
		this(name,objectFieldName,type,fieldValueStrategy,notNull);
		this.constraint1 = constraint1;
	}
	
	public EntityFieldDefinition(String name, String objectFieldName, FieldType type, FieldValueStrategy fieldValueStrategy, int constraint1) {
		this(name,objectFieldName,type,fieldValueStrategy);
		this.constraint1 = constraint1;
	}

	public int getConstraint1() {
		return constraint1;
	}

	public void setConstraint1(int constraint1) {
		this.constraint1 = constraint1;
	}

	public int getConstraint2() {
		return constraint2;
	}

	public void setConstraint2(int constraint2) {
		this.constraint2 = constraint2;
	}

	public String getName() {
		return name;
	}

	public FieldType getType() {
		return type;
	}
	
	public String getTypeName() {
		switch(type) {
		case NUMBER: return "NUMBER";
		case VARCHAR: return "VARCHAR";
		case DATE: return "DATE";
		case BLOB: return "BLOB";
		}
		throw new RuntimeException("Type name not defined for type "+type);
	}

	public String getConstraintsSql() {
		if (constraint1 != null) {
			if (constraint2 != null) {
				return "("+constraint1+","+constraint2+")";
			} else {
				return "("+constraint1+")";
			}
		}
		return "";
	}
	
	public String getNotNullSql() {
		if (notNull) {
			return " NOT NULL";
		}
		return "";
	}

	public boolean isVersionField() {
		return versionField;
	}

	public void setVersionField(boolean versionField) {
		this.versionField = versionField;
	}

	public boolean isPrimaryKeyField() {
		return primaryKeyField;
	}

	public void setPrimaryKeyField(boolean primaryKeyField) {
		this.primaryKeyField = primaryKeyField;
	}

	public FieldValueStrategy getValueStrategy() {
		return valueStrategy;
	}
	
}
