/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.genesis.impl;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Qualifier;
import org.iworkz.common.helper.ReflectionHelper;
import org.iworkz.genesis.Injector;
import org.iworkz.genesis.Module;
import org.iworkz.genesis.PostProcessor;
import org.iworkz.genesis.impl.AbstractImplementationFinder;
import org.iworkz.genesis.impl.Binding;
import org.iworkz.genesis.impl.ImplementationFinder;
import org.iworkz.genesis.impl.InjectionContext;
import org.iworkz.genesis.impl.Supplier;
import org.iworkz.genesis.impl.scope.ScopeContext;

public abstract class AbstractInjector
implements Injector {
    ReflectionHelper reflectionHelper;
    private Map<Class<?>, Supplier<?>> suppliers;
    private Map<Class<?>, Binding<?>> bindings;
    private Map<Class<?>, ScopeContext> contexts;
    private Set<Module> modules;
    private Set<ClassLoader> registeredClassLoaders;
    private Set<ImplementationFinder> implementationFinders;
    private Set<PostProcessor> postProcessors;
    protected final Module[] modulesForSetup;

    public AbstractInjector(Module ... modules) {
        this.modulesForSetup = modules;
    }

    public Module[] getConfiguredModules() {
        return this.modulesForSetup;
    }

    protected void setup() {
        Module[] modules = this.getConfiguredModules();
        this.modules = new HashSet<Module>();
        if (modules != null && modules.length > 0) {
            for (Module module : modules) {
                this.modules.add(module);
            }
        }
        this.bindings = new HashMap();
        this.suppliers = new HashMap();
        this.contexts = new HashMap();
        this.suppliers.put(Injector.class, new Supplier<AbstractInjector>(this));
        this.registeredClassLoaders = new HashSet<ClassLoader>();
        this.implementationFinders = new HashSet<ImplementationFinder>();
        this.postProcessors = new HashSet<PostProcessor>();
        if (modules != null) {
            for (Module module : modules) {
                module.configure();
                if (module.getClassLoaders() != null) {
                    this.registeredClassLoaders.addAll(module.getClassLoaders());
                }
                if (module.getBindings() != null) {
                    for (Class<?> clazz : module.getBindings().keySet()) {
                        Binding<?> binding = module.getBindings().get(clazz);
                        this.bindings.put(clazz, binding);
                    }
                }
                if (module.getScopes() != null) {
                    for (Class clazz : module.getScopes().keySet()) {
                        ScopeContext context = module.getScopes().get(clazz);
                        this.contexts.put(clazz, context);
                    }
                }
                if (module.getImplementationFinders() != null) {
                    for (ImplementationFinder implementationFinder : module.getImplementationFinders()) {
                        if (!(implementationFinder instanceof AbstractImplementationFinder)) continue;
                        ((AbstractImplementationFinder)implementationFinder).setReflectionHelper(this.reflectionHelper);
                    }
                    this.implementationFinders.addAll(module.getImplementationFinders());
                }
                if (module.getPostProcessors() == null) continue;
                this.postProcessors.addAll(module.getPostProcessors());
            }
        }
        this.createPreliminaryReflectionHelper();
        this.configureImplementationFinders();
    }

    protected void postSetup() {
        this.createFinalReflectionHelper();
        this.configureImplementationFinders();
    }

    protected void createPreliminaryReflectionHelper() {
        this.reflectionHelper = new ReflectionHelper();
    }

    protected void createFinalReflectionHelper() {
        this.reflectionHelper = this.getInstance(ReflectionHelper.class);
    }

    protected void configureImplementationFinders() {
        if (this.implementationFinders != null) {
            for (ImplementationFinder implementationFinder : this.implementationFinders) {
                if (!(implementationFinder instanceof AbstractImplementationFinder)) continue;
                ((AbstractImplementationFinder)implementationFinder).setReflectionHelper(this.reflectionHelper);
            }
        }
    }

    @Override
    public void injectMembers(Object instance) {
        if (instance != null) {
            if (this.modules == null) {
                this.setup();
                this.postSetup();
            }
            InjectionContext ctx = new InjectionContext();
            this.injectMembers(instance, instance.getClass(), ctx);
            this.postProcess(ctx);
        }
    }

    protected void postProcess(InjectionContext ctx) {
        if (ctx.createdInstances != null && this.postProcessors != null) {
            for (PostProcessor postProcessor : this.postProcessors) {
                this.postProcess(postProcessor, ctx.createdInstances);
            }
        }
    }

    public void postProcess(PostProcessor postProcessor, Map<Object, Set<Object>> createdInstances) {
        for (Object instance : createdInstances.keySet()) {
            postProcessor.process(instance, createdInstances.get(instance));
        }
    }

    protected void injectMembers(Object instance, Class<?> classWithMembers, InjectionContext ctx) {
        for (Field field : this.reflectionHelper.getAllFields(classWithMembers)) {
            Inject injectAnnotation = field.getAnnotation(Inject.class);
            if (injectAnnotation == null) continue;
            try {
                field.setAccessible(true);
                Class fieldClass = field.getType();
                boolean isProvider = false;
                if (Provider.class == fieldClass) {
                    ParameterizedType parameterizedType;
                    Type typeArgument;
                    isProvider = true;
                    Type genericType = field.getGenericType();
                    if (genericType instanceof ParameterizedType && (typeArgument = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()[0]) instanceof Class) {
                        fieldClass = (Class)typeArgument;
                    }
                }
                Object injectedObject = this.get(fieldClass, isProvider, field, ctx);
                ctx.putInjectedObject(instance, injectedObject);
                field.set(instance, injectedObject);
            }
            catch (Exception e) {
                throw new RuntimeException("Can not inject field '" + field.getName() + "' of class '" + instance.getClass().getCanonicalName() + "'", e);
            }
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(classWithMembers);
            for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                Method setter = pd.getWriteMethod();
                if (setter == null) continue;
                setter.setAccessible(true);
                if (!setter.isAnnotationPresent(Inject.class)) continue;
                Parameter parameter = setter.getParameters()[0];
                Class parameterClass = setter.getParameterTypes()[0];
                boolean isProvider = false;
                if (Provider.class == parameterClass) {
                    ParameterizedType parameterizedType;
                    Type typeArgument;
                    isProvider = true;
                    Type genericType = setter.getGenericParameterTypes()[0];
                    if (genericType instanceof ParameterizedType && (typeArgument = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()[0]) instanceof Class) {
                        parameterClass = (Class)typeArgument;
                    }
                }
                Object injectedObject = this.get(parameterClass, isProvider, parameter, ctx);
                ctx.putInjectedObject(instance, injectedObject);
                setter.invoke(instance, injectedObject);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Can not inject setter of class '" + instance.getClass().getCanonicalName() + "'", e);
        }
    }

    @Override
    public <T> T getInstance(Class<T> instanceClass) {
        if (instanceClass != null) {
            if (this.modules == null) {
                this.setup();
                this.postSetup();
            }
            InjectionContext ctx = new InjectionContext();
            T t = this.get(instanceClass, false, null, ctx);
            this.postProcess(ctx);
            return t;
        }
        return null;
    }

    @Override
    public <T> T getInstance(String className) {
        if (className != null) {
            if (this.modules == null) {
                this.setup();
                this.postSetup();
            }
            Class implementationClass = null;
            for (ClassLoader classLoader : this.registeredClassLoaders) {
                try {
                    implementationClass = this.reflectionHelper.load(classLoader, className);
                }
                catch (ClassNotFoundException e) {}
            }
            if (implementationClass != null) {
                return this.getInstance(implementationClass);
            }
            throw new RuntimeException("Class not found '" + className + "'");
        }
        return null;
    }

    protected <T> T get(Class<T> instanceClass, boolean isProvider, AnnotatedElement annotatedElement, InjectionContext ctx) {
        Object annotation = null;
        if (annotatedElement != null) {
            if (annotatedElement.isAnnotationPresent(Named.class)) {
                annotation = annotatedElement.getAnnotation(Named.class);
            } else {
                for (Annotation elementAnnotation : annotatedElement.getAnnotations()) {
                    Class<? extends Annotation> annotationType = elementAnnotation.annotationType();
                    if (!annotationType.isAnnotationPresent(Qualifier.class)) continue;
                    annotation = elementAnnotation;
                    break;
                }
            }
        }
        if (ctx.creationStack.contains(instanceClass)) {
            throw new RuntimeException("Circular dependency detected during creation of '" + instanceClass + "', stack = " + ctx.creationStack.toString());
        }
        Supplier<Object> supplier = this.suppliers.get(instanceClass);
        if (supplier == null) {
            Binding<?> binding = this.bindings.get(instanceClass);
            if (binding != null) {
                supplier = new Supplier(instanceClass, binding.implementationClass, binding.getInstance(), this, binding.getScope());
                if (binding.annotationBindings != null) {
                    supplier.annotationProviders = new HashMap();
                    for (Annotation annotationInstance : binding.annotationBindings.keySet()) {
                        Binding annotationBinding = binding.annotationBindings.get(annotationInstance);
                        supplier.annotationProviders.put(annotationInstance, new Supplier(instanceClass, annotationBinding.implementationClass, annotationBinding.getInstance(), this, annotationBinding.getScope()));
                    }
                }
                if (binding.annotationClassBindings != null) {
                    supplier.annotationClassProviders = new HashMap();
                    for (Class<? extends Annotation> annotationClass : binding.annotationClassBindings.keySet()) {
                        Binding annotationClassBinding = binding.annotationClassBindings.get(annotationClass);
                        supplier.annotationClassProviders.put(annotationClass, new Supplier(instanceClass, annotationClassBinding.implementationClass, annotationClassBinding.getInstance(), this, annotationClassBinding.getScope()));
                    }
                }
            } else {
                supplier = new Supplier<Object>(instanceClass, null, null, this, null);
            }
            this.suppliers.put(instanceClass, supplier);
        }
        if (isProvider) {
            final Supplier<?> finalProvider = supplier;
            Named finalAnnotation = annotation;
            final InjectionContext parentCtx = ctx;
            return (T)new Provider<T>((Annotation)finalAnnotation){
                final /* synthetic */ Annotation val$finalAnnotation;
                {
                    this.val$finalAnnotation = annotation;
                }

                public T get() {
                    if (parentCtx.creationStack.size() != 0) {
                        throw new RuntimeException("Provider 'get()' invoked before parent injection finished (probably in a constructor).");
                    }
                    InjectionContext ctx = new InjectionContext();
                    Object t = finalProvider.getInstance(AbstractInjector.this, this.val$finalAnnotation, ctx);
                    AbstractInjector.this.postProcess(ctx);
                    return t;
                }
            };
        }
        return (T)supplier.getInstance(this, (Annotation)annotation, ctx);
    }

    public <T> Class<? extends T> findImplementationClass(Class<T> injectedClass) {
        Class<T> implementationClass = null;
        for (ClassLoader classLoader : this.registeredClassLoaders) {
            for (ImplementationFinder implementationFinder : this.implementationFinders) {
                Class<T> implementationClassFromModule = implementationFinder.find(classLoader, injectedClass);
                if (implementationClassFromModule == null) continue;
                implementationClass = implementationClassFromModule;
            }
        }
        if (implementationClass != null) {
            return implementationClass;
        }
        return injectedClass;
    }

    public ScopeContext getContext(Class<?> scope) {
        ScopeContext context = this.contexts.get(scope);
        if (context == null) {
            throw new RuntimeException("No context defined for scope '" + scope.getCanonicalName() + "'");
        }
        return context;
    }
}

