/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.habitat.dao;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;

public class BlobHelper {
    private static final int BUFFER_SIZE = 4096;

    private BlobHelper() {
    }

    public static void writeBlobToOutputStream(Blob blob, OutputStream outputStream) throws Exception {
        try (InputStream inputStream = blob.getBinaryStream();){
            BlobHelper.writeInputStreamToOutputStream(inputStream, outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeClobToOutputStream(Clob clob, OutputStream outputStream) throws Exception {
        Reader reader = clob.getCharacterStream();
        PrintWriter writer = new PrintWriter(outputStream);
        try {
            BlobHelper.writeReaderToWriter(reader, writer);
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    public static void writeReaderToWriter(Reader rd, Writer wr) throws Exception {
        char[] buffer = new char[4096];
        int bytesRead = -1;
        while ((bytesRead = rd.read(buffer)) != -1) {
            wr.write(buffer, 0, bytesRead);
        }
    }

    public static void writeInputStreamToOutputStream(InputStream is, OutputStream outputStream) throws Exception {
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        while ((bytesRead = is.read(buffer)) != -1) {
            outputStream.write(buffer, 0, bytesRead);
        }
    }

    public static byte[] getBytesFromInputStream(InputStream inputStream) throws Exception {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            BlobHelper.writeInputStreamToOutputStream(inputStream, outputStream);
            outputStream.flush();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }
}

