/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.habitat.dao;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.sql.DataSource;
import org.iworkz.habitat.dao.Context;
import org.iworkz.habitat.dao.DataSourceProvider;

@Singleton
public class ContextAccess {
    private final ThreadLocal<Context> context = new ThreadLocal<Context>(){

        @Override
        protected Context initialValue() {
            return ContextAccess.this.createContext();
        }
    };
    @Inject
    protected DataSourceProvider dataSourceProvider;

    public Context getContext() {
        return this.context.get();
    }

    public void startContext() {
        this.getContext().start();
    }

    public void startContext(DataSource dataSource) {
        Context contextToStart = this.getContext();
        contextToStart.setDataSource(dataSource);
        contextToStart.start();
    }

    public void closeContext() {
        try {
            this.getContext().close();
        }
        finally {
            this.context.remove();
        }
    }

    protected Context createContext() {
        return new Context(this.dataSourceProvider.getDataSource());
    }

    protected DataSource getDataSource() {
        return this.dataSourceProvider.getDataSource();
    }
}

