/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.genesis.impl;

import java.util.List;
import java.util.Map;
import org.iworkz.genesis.InjectorFactory;
import org.iworkz.genesis.Module;
import org.iworkz.genesis.impl.AbstractBundleInjectorFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={InjectorFactory.class}, immediate=true, configurationPid={"org.iworkz.genesis.DefaultBundleInjectorFactory"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class DefaultBundleInjectorFactory
extends AbstractBundleInjectorFactory {
    public static final String CONFIGURATION_PID = "org.iworkz.genesis.DefaultBundleInjectorFactory";
    public static final String ENABLE_DYNAMIC_MODULE_REGISTRATION = "enableDynamicModuleRegistration";
    private static final Logger logger = LoggerFactory.getLogger(DefaultBundleInjectorFactory.class);
    private boolean enableDynamicModuleRegistration = true;

    @Override
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unregisterModule")
    public void registerModule(Module module) {
        super.registerModule(module);
    }

    @Override
    public void unregisterModule(Module module) {
        super.unregisterModule(module);
    }

    @Modified
    public void modified(Map<String, Object> properties) {
        this.updateConfiguration(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateConfiguration(Map<String, Object> properties) {
        List list = this.registeredModules;
        synchronized (list) {
            if (properties != null) {
                logger.debug("Configuration modified: " + properties);
                Boolean flag = (Boolean)properties.get(ENABLE_DYNAMIC_MODULE_REGISTRATION);
                if (flag != null && this.enableDynamicModuleRegistration != flag) {
                    this.enableDynamicModuleRegistration = flag;
                    if (flag.booleanValue()) {
                        logger.info("Dynamic module registration is enabled");
                    } else {
                        logger.info("Dynamic module registration is disabled");
                    }
                    this.updateInjector();
                }
            }
        }
    }

    @Override
    protected void registerInjector() {
        if (this.enableDynamicModuleRegistration) {
            super.registerInjector();
        }
    }

    @Activate
    public void activate(BundleContext context, Map<String, Object> properties) throws Exception {
        logger.info("activate '" + this.getClass().getCanonicalName() + "'");
        this.updateConfiguration(properties);
    }

    @Deactivate
    public void deactivate(BundleContext context) throws Exception {
        logger.info("deactivate '" + this.getClass().getCanonicalName() + "'");
    }
}

