/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.habitat.entity;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.sql.Blob;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Version;
import org.iworkz.common.helper.ReflectionHelper;
import org.iworkz.habitat.dao.EntityDao;
import org.iworkz.habitat.dao.FieldType;
import org.iworkz.habitat.dialect.DatabaseDialect;
import org.iworkz.habitat.entity.EntityDefinition;
import org.iworkz.habitat.entity.EntityFieldDefinition;
import org.iworkz.habitat.entity.FieldValueStrategy;

@Singleton
public class EntityDefinitionCreator {
    @Inject
    protected ReflectionHelper reflectionHelper;
    @Inject
    protected DatabaseDialect databaseDialect;

    public EntityDefinition readEntityDefinition(Class<? extends EntityDao> daoClass) {
        Field[] recordClassFields;
        Class<?> classWithEntityAnnotation = this.getClassWithEntityAnnotation(daoClass);
        if (classWithEntityAnnotation == null) {
            throw new RuntimeException("The record class is not defined");
        }
        Entity entityAnnotation = classWithEntityAnnotation.getAnnotation(Entity.class);
        if (entityAnnotation.name() == null) {
            throw new RuntimeException("The name of the entity annotation is not defined");
        }
        EntityDefinition entityDefinition = new EntityDefinition(entityAnnotation.name(), this.databaseDialect, this.reflectionHelper);
        for (Field field : recordClassFields = this.reflectionHelper.getAllFields(classWithEntityAnnotation)) {
            Version versionAnnotation;
            Id idAnnotation;
            FieldValueStrategy fieldValueStrategy = this.fieldValueStrategyFor(field);
            Column columnAnnotation = field.getAnnotation(Column.class);
            if (columnAnnotation != null) {
                String columnName = columnAnnotation.name();
                FieldType columnType = this.columnTypeForType(field.getGenericType());
                Integer constraint1 = columnAnnotation.length();
                Boolean nullable = !columnAnnotation.nullable();
                EntityFieldDefinition column = new EntityFieldDefinition(this.databaseDialect, columnName, field.getName(), columnType, fieldValueStrategy, constraint1, nullable);
                entityDefinition.addField(column);
            }
            if ((idAnnotation = field.getAnnotation(Id.class)) != null) {
                entityDefinition.setPrimaryKey(columnAnnotation.name());
            }
            if ((versionAnnotation = field.getAnnotation(Version.class)) == null) continue;
            entityDefinition.setVersion(columnAnnotation.name());
        }
        return entityDefinition;
    }

    protected FieldValueStrategy fieldValueStrategyFor(Field field) {
        GeneratedValue generatedValue = field.getAnnotation(GeneratedValue.class);
        if (generatedValue != null) {
            if (GenerationType.AUTO == generatedValue.strategy()) {
                return FieldValueStrategy.AUTO;
            }
            return FieldValueStrategy.GENERATED;
        }
        return FieldValueStrategy.MANUAL;
    }

    protected Class<?> getClassWithEntityAnnotation(Class<? extends EntityDao> daoClass) {
        Class<?>[] innerClasses;
        for (Class<?> c : innerClasses = daoClass.getDeclaredClasses()) {
            Entity entityAnnotation = c.getAnnotation(Entity.class);
            if (entityAnnotation == null) continue;
            return c;
        }
        throw new RuntimeException("Entity class not found");
    }

    protected FieldType columnTypeForType(Type type) {
        if (type == String.class) {
            return FieldType.VARCHAR;
        }
        if (type == Integer.class) {
            return FieldType.NUMBER;
        }
        if (type == Blob.class) {
            return FieldType.BLOB;
        }
        return FieldType.VARCHAR;
    }
}

