package org.iworkz.habitat.db;

import javax.inject.Inject;
import javax.inject.Singleton;

import org.iworkz.habitat.dao.ContextAccess;
import org.iworkz.habitat.dao.DatabaseHelper;
import org.iworkz.habitat.dao.GenericDao;

@Singleton
public class DatabaseSetup {

	@Inject
	DatabaseHelper databaseHelper;
	
	@Inject
	ContextAccess contextAccess;
	
	public void setup() {
		contextAccess.startContext();
		try {
			for (GenericDao dao : allDataAccessObjects()) {
				databaseHelper.createTableIfNotExists(dao);
			}
		} finally {
			contextAccess.closeContext();
		}
	}
	
	protected GenericDao[] allDataAccessObjects() {
		return new GenericDao[0];
	}

}
