package org.iworkz.habitat.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import javax.inject.Singleton;

@Singleton
public class StringHelper {

    public boolean hasValue(String s) {
        return s != null && s.length() > 0;
    }

    public String toFirstUpper(String s) {
        if (hasValue(s)) {
            char first = Character.toUpperCase(s.charAt(0));
            return first + s.substring(1);
        }
        return s;
    }

    public String underLineSeperatedToCamelCase(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        StringTokenizer columnNameTokenizer = new StringTokenizer(s, "_");
        boolean first = true;
        StringBuilder buffer = new StringBuilder();
        while (columnNameTokenizer.hasMoreTokens()) {
            String token = columnNameTokenizer.nextToken().toLowerCase();
            if (!first) {
                token = toFirstUpper(token);
            } else {
                first = false;
            }
            buffer.append(token);
        }
        return buffer.toString();
    }

    public String camelCaseToUnderLineSeperated(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        StringBuilder buffer = new StringBuilder();
        String[] nameParts = splitByCamelCase(s);
        boolean first = true;
        for (String namePart : nameParts) {
            if (!first) {
                buffer.append('_');
            } else {
                first = false;
            }
            buffer.append(namePart.toLowerCase());
        }
        return buffer.toString();
    }

    public String[] splitByCamelCase(String str) {
        return splitByCharacterType(str, true);
    }

    protected String[] splitByCharacterType(String str, boolean camelCase) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return new String[] {};
        }
        char[] c = str.toCharArray();
        List<String> list = new ArrayList<String>();
        int tokenStart = 0;
        int currentType = Character.getType(c[tokenStart]);
        for (int pos = tokenStart + 1; pos < c.length; pos++) {
            int type = Character.getType(c[pos]);
            if (type == currentType) {
                continue;
            }
            if (camelCase && type == Character.LOWERCASE_LETTER && currentType == Character.UPPERCASE_LETTER) {
                int newTokenStart = pos - 1;
                if (newTokenStart != tokenStart) {
                    list.add(new String(c, tokenStart, newTokenStart - tokenStart));
                    tokenStart = newTokenStart;
                }
            } else {
                list.add(new String(c, tokenStart, pos - tokenStart));
                tokenStart = pos;
            }
            currentType = type;
        }
        list.add(new String(c, tokenStart, c.length - tokenStart));
        return list.toArray(new String[list.size()]);
    }

}
