package org.iworkz.habitat.sync;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;

/**
 * Convenient support for 'double-checked locking'-pattern for values of a Map.
 *
 * @param <T>
 */
public class SyncnronizedValueAcess<T> {

    final Map<String, T> map;

    public SyncnronizedValueAcess(Map<String, T> map) {
        this.map = map;
    }

    public T getValue(String key) {
        return this.map.get(key);
    }

    public T getOrCreateValue(String key, Supplier<T> valueSupplier) {
        T value = getValue(key);
        if (value == null) {
            synchronized (this) {
                value = getValue(key);
                if (value == null) {
                    value = valueSupplier.get();
                    this.map.put(key, value);
                }
            }
        }
        return value;
    }

    public T getOrCreateValue(String key, Consumer<T> valueModifier) {
        T value = getValue(key);
        if (value == null) {
            synchronized (this) {
                value = getValue(key);
                if (value == null) {
                    value = createValue();
                    valueModifier.accept(value);
                    this.map.put(key, value);
                }
            }
        }
        return value;
    }

    protected T createValue() {
        throw new RuntimeException("Creation of value not implemented");
    }
}
