/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.genesis.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Scope;
import javax.inject.Singleton;
import org.iworkz.genesis.impl.AbstractInjector;
import org.iworkz.genesis.impl.InjectionContext;
import org.iworkz.genesis.impl.scope.NoScope;
import org.iworkz.genesis.impl.scope.ScopeContext;

public class Supplier<T> {
    protected final Class<T> injectedClass;
    protected Class<? extends T> implementationClass;
    protected boolean singleton;
    protected Class<?> scope;
    protected T instance;
    protected AbstractInjector injector;
    protected Map<Annotation, Supplier<T>> annotationProviders;
    protected Map<Class<? extends Annotation>, Supplier<T>> annotationClassProviders;

    public Supplier(T instance) {
        this(instance.getClass(), instance.getClass(), instance, null, null);
    }

    public Supplier(Supplier<T> supplier, boolean scoped) {
        this.injector = supplier.injector;
        this.injectedClass = supplier.injectedClass;
        this.instance = supplier.instance;
        this.implementationClass = supplier.implementationClass;
        if (scoped) {
            this.singleton = true;
        } else {
            this.singleton = supplier.singleton;
            this.scope = supplier.scope;
        }
    }

    public Supplier(Class<T> injectedClass, Class<? extends T> implementationClass, T instance, AbstractInjector injector, Class<?> scope) {
        this.injector = injector;
        this.injectedClass = injectedClass;
        this.instance = instance;
        this.implementationClass = instance != null ? instance.getClass() : (implementationClass != null ? implementationClass : injector.findImplementationClass(injectedClass));
        if (scope != null) {
            if (scope != NoScope.class) {
                this.scope = scope;
            }
        } else if (this.implementationClass != null) {
            this.scope = this.getScopeAnnotationType(this.implementationClass);
        }
        if (this.scope != null) {
            this.singleton = Singleton.class.equals(this.scope);
        }
    }

    private Class<?> getScopeAnnotationType(Class<? extends T> implementationClass) {
        for (Annotation classAnnotation : implementationClass.getAnnotations()) {
            Class<? extends Annotation> annotationType = classAnnotation.annotationType();
            if (!annotationType.isAnnotationPresent(Scope.class)) continue;
            return annotationType;
        }
        return null;
    }

    public Object getInstance(AbstractInjector injector, Annotation annotation, InjectionContext ctx) {
        if (annotation != null) {
            Supplier<T> annotationClassProvider;
            Supplier<T> annotationProvider;
            if (this.annotationProviders != null && (annotationProvider = this.annotationProviders.get(annotation)) != null) {
                return annotationProvider.getInstance(injector, null, ctx);
            }
            if (this.annotationClassProviders != null && (annotationClassProvider = this.annotationClassProviders.get(annotation.annotationType())) != null) {
                return annotationClassProvider.getInstance(injector, null, ctx);
            }
            throw new RuntimeException("No binding found for annotation " + annotation.annotationType().getCanonicalName() + " (injected class: " + this.injectedClass.getCanonicalName() + " )");
        }
        if (this.scope != null && !this.singleton && this.injectedClass != null) {
            ScopeContext scopeContext = injector.getContext(this.scope);
            Supplier<T> scopedSupplier = scopeContext.get(this.injectedClass, this);
            return scopedSupplier.getInstance(injector, null, ctx);
        }
        if (this.instance != null) {
            return this.instance;
        }
        ctx.creationStack.push(this.injectedClass);
        T newInstance = this.createInstance(injector, ctx);
        if (this.singleton) {
            this.instance = newInstance;
        }
        ctx.creationStack.pop();
        injector.injectMembers(newInstance, newInstance.getClass(), ctx);
        return newInstance;
    }

    public T createInstance(AbstractInjector injector, InjectionContext ctx) {
        if (this.implementationClass == null) {
            this.implementationClass = this.injectedClass;
        }
        try {
            Constructor<T> constructor = this.getConstructor(this.implementationClass);
            if (constructor != null) {
                constructor.setAccessible(true);
                if (constructor.getParameterCount() > 0) {
                    Parameter[] parameters = constructor.getParameters();
                    Type[] genericParameterTypes = constructor.getGenericParameterTypes();
                    Object[] initargs = new Object[parameters.length];
                    for (int i = 0; i < parameters.length; ++i) {
                        Parameter parameter = parameters[i];
                        Class parameterClass = parameter.getType();
                        boolean isProvider = false;
                        if (Provider.class == parameterClass) {
                            ParameterizedType parameterizedType;
                            Type typeArgument;
                            isProvider = true;
                            Type genericType = genericParameterTypes[i];
                            if (genericType instanceof ParameterizedType && (typeArgument = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()[0]) instanceof Class) {
                                parameterClass = (Class)typeArgument;
                            }
                        }
                        initargs[i] = injector.get(parameterClass, isProvider, parameter, ctx);
                    }
                    T t = constructor.newInstance(initargs);
                    ctx.putInjectedObjects(t, initargs);
                    return t;
                }
                T t = constructor.newInstance(new Object[0]);
                ctx.createdInstances.put(t, null);
                return t;
            }
            throw new RuntimeException("No suitable constructor found for injection");
        }
        catch (Exception e) {
            throw new RuntimeException("Can not create singleton for class '" + this.implementationClass.getCanonicalName() + "'", e);
        }
    }

    public Constructor<? extends T> getConstructor(Class<? extends T> implementationClass) {
        Constructor<?> d = null;
        for (Constructor<?> c : implementationClass.getDeclaredConstructors()) {
            if (c.isAnnotationPresent(Inject.class)) {
                return c;
            }
            if (c.getParameterCount() != 0) continue;
            d = c;
        }
        return d;
    }
}

