/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.habitat.entity;

import org.iworkz.habitat.dao.FieldType;
import org.iworkz.habitat.dialect.DatabaseDialect;
import org.iworkz.habitat.entity.FieldValueStrategy;

public class EntityFieldDefinition {
    private final String name;
    final String objectFieldName;
    private final FieldType type;
    private Integer constraint1;
    private Integer constraint2;
    boolean notNull;
    boolean versionField;
    boolean primaryKeyField;
    private final FieldValueStrategy valueStrategy;
    private DatabaseDialect databaseDialect;

    public EntityFieldDefinition(DatabaseDialect databaseDialect, String name, String objectFieldName, FieldType type, FieldValueStrategy fieldValueStrategy, boolean notNull) {
        this.databaseDialect = databaseDialect;
        this.name = name;
        this.objectFieldName = objectFieldName;
        this.type = type;
        this.valueStrategy = fieldValueStrategy;
        this.notNull = notNull;
    }

    public EntityFieldDefinition(DatabaseDialect databaseDialect, String name, String objectFieldName, FieldType type, FieldValueStrategy fieldValueStrategy) {
        this(databaseDialect, name, objectFieldName, type, fieldValueStrategy, false);
    }

    public EntityFieldDefinition(DatabaseDialect databaseDialect, String name, String objectFieldName, FieldType type, FieldValueStrategy fieldValueStrategy, Integer constraint1, boolean notNull) {
        this(databaseDialect, name, objectFieldName, type, fieldValueStrategy, notNull);
        this.constraint1 = constraint1;
    }

    public EntityFieldDefinition(DatabaseDialect databaseDialect, String name, String objectFieldName, FieldType type, FieldValueStrategy fieldValueStrategy, Integer constraint1) {
        this(databaseDialect, name, objectFieldName, type, fieldValueStrategy);
        this.constraint1 = constraint1;
    }

    public Integer getConstraint1() {
        return this.constraint1;
    }

    public void setConstraint1(Integer constraint1) {
        this.constraint1 = constraint1;
    }

    public Integer getConstraint2() {
        return this.constraint2;
    }

    public void setConstraint2(Integer constraint2) {
        this.constraint2 = constraint2;
    }

    public String getName() {
        return this.name;
    }

    public FieldType getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.databaseDialect.getTypeName(this);
    }

    public String getConstraintsSql() {
        return this.databaseDialect.getConstraintsSql(this);
    }

    public String getNotNullSql() {
        if (this.notNull) {
            return " NOT NULL";
        }
        return "";
    }

    public boolean isVersionField() {
        return this.versionField;
    }

    public void setVersionField(boolean versionField) {
        this.versionField = versionField;
    }

    public boolean isPrimaryKeyField() {
        return this.primaryKeyField;
    }

    public void setPrimaryKeyField(boolean primaryKeyField) {
        this.primaryKeyField = primaryKeyField;
    }

    public FieldValueStrategy getValueStrategy() {
        return this.valueStrategy;
    }
}

