package org.iworkz.habitat.command;

import java.sql.Connection;

import javax.inject.Inject;

import org.iworkz.common.helper.CloneHelper;
import org.iworkz.common.helper.ReflectionHelper;
import org.iworkz.habitat.dao.ConnectionProvider;
import org.iworkz.habitat.dao.ExceptionFactory;
import org.iworkz.habitat.dao.GenericDao;
import org.iworkz.habitat.helper.RecordHelper;
import org.iworkz.habitat.helper.StringHelper;
import org.iworkz.habitat.sql.SQLBuilder;

public abstract class AbstractExecutor {

    @Inject
    protected StringHelper stringHelper;

    @Inject
    protected ReflectionHelper reflectionHelper;

    @Inject
    protected CommandHelper commandHelper;

    @Inject
    protected RecordHelper recordHelper;

    @Inject
    protected SQLBuilder commandBuilder;

    @Inject
    protected ExceptionFactory exceptionFactory;

    @Inject
    protected CloneHelper beanHelper;

    protected <T> T cloneBean(T obj) {
        return this.beanHelper.cloneBean(obj);
    }

    /**
     * Get a connection.
     * In case a connectionProvider exists, get the connection from the connectionProvider. Otherwise get it from the dao.
     * 
     * @param connectionProvider
     * @param dao
     * @return
     */
    protected Connection getConnection(ConnectionProvider connectionProvider, GenericDao dao) {
        if (connectionProvider != null) {
            return connectionProvider.get();
        } else {
            return dao.getConnection();
        }
    }

}
