/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.common.helper;

import java.io.Closeable;
import java.lang.reflect.Array;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.iworkz.common.helper.ReflectionHelper;
import org.iworkz.common.reflection.PropertyInfo;

@Singleton
public class CloneHelper {
    private static final Object PROPERTIES_CACHE_LOCK = new Object();
    private static final Map<Class<?>, PropertyInfo[]> PROPERTIES_CACHE = new IdentityHashMap();
    @Inject
    protected ReflectionHelper reflectionHelper;

    public <T> T cloneBean(T source) {
        IdentityHashMap<Object, Object> instanceMap = new IdentityHashMap<Object, Object>();
        return this.cloneBean(source, instanceMap);
    }

    public <T> T cloneBean(T source, Map<Object, Object> instanceMap) {
        if (source != null) {
            Object destination;
            if (instanceMap.containsKey(source)) {
                return (T)instanceMap.get(source);
            }
            Class<?> sourceClass = source.getClass();
            if (sourceClass.isArray()) {
                Class<?> componentType = sourceClass.getComponentType();
                boolean finalImmutuable = this.reflectionHelper.isImmutable(componentType);
                destination = this.cloneArray(source, componentType, finalImmutuable, instanceMap);
            } else {
                destination = Collection.class.isAssignableFrom(sourceClass) ? this.cloneCollection((Collection)source, instanceMap) : (Map.class.isAssignableFrom(sourceClass) ? this.cloneMap((Map)source, instanceMap) : (this.isCloneRequired(sourceClass) ? this.clone(source, instanceMap) : source));
            }
            return (T)destination;
        }
        return null;
    }

    protected <T> T clone(T source, Map<Object, Object> instanceMap) {
        T destination = this.createCustomClone(source, instanceMap);
        if (destination != null) {
            instanceMap.put(source, destination);
        } else {
            destination = this.createClone(source);
            instanceMap.put(source, destination);
            this.cloneProperties(source, destination, instanceMap);
        }
        return destination;
    }

    protected <T> T createClone(T source) {
        return (T)this.reflectionHelper.createObject(source.getClass());
    }

    protected <T> T createCustomClone(T source, Map<Object, Object> instanceMap) {
        Date destination = null;
        Class<?> sourceClass = source.getClass();
        if (Date.class.isAssignableFrom(sourceClass)) {
            destination = java.sql.Date.class == sourceClass ? new java.sql.Date(((java.sql.Date)source).getTime()) : (Date.class == sourceClass ? new Date(((Date)source).getTime()) : (Time.class == sourceClass ? new Time(((Time)source).getTime()) : (Timestamp.class == sourceClass ? new Timestamp(((Timestamp)source).getTime()) : null)));
        }
        return (T)destination;
    }

    protected <T> void cloneProperties(T source, T destination, Map<Object, Object> instanceMap) {
        if (source != null) {
            if (destination == null) {
                throw new IllegalArgumentException("The destination bean is null");
            }
            try {
                PropertyInfo[] propertyInfos;
                for (PropertyInfo propertyInfo : propertyInfos = this.getPropertyInfos(source.getClass())) {
                    Object value = propertyInfo.getReadMethod().invoke(source, new Object[0]);
                    if (value == null) continue;
                    if (propertyInfo.isImmutable()) {
                        propertyInfo.getWriteMethod().invoke(destination, value);
                        continue;
                    }
                    if (propertyInfo.isMap()) {
                        propertyInfo.getWriteMethod().invoke(destination, this.cloneMap((Map)value, instanceMap));
                        continue;
                    }
                    if (propertyInfo.isCollection()) {
                        propertyInfo.getWriteMethod().invoke(destination, this.cloneCollection((Collection)value, instanceMap));
                        continue;
                    }
                    if (propertyInfo.isArray()) {
                        Class<?> componentType = value.getClass().getComponentType();
                        propertyInfo.getWriteMethod().invoke(destination, this.cloneArray(value, componentType, propertyInfo.isComponentImmutable(), instanceMap));
                        continue;
                    }
                    propertyInfo.getWriteMethod().invoke(destination, this.cloneBean(value, instanceMap));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Can not clone bean '" + source.getClass().getCanonicalName() + "'", e);
            }
        }
    }

    protected <T> Collection<T> createCollection(Collection<T> sourceCollection) {
        return (Collection)this.reflectionHelper.createObject(sourceCollection.getClass());
    }

    protected <T, R> Map<T, R> createMap(Map<T, R> sourceMap) {
        return (Map)this.reflectionHelper.createObject(sourceMap.getClass());
    }

    protected boolean isCloneRequired(Class<?> sourceClass) {
        if (this.reflectionHelper.isImmutable(sourceClass)) {
            return false;
        }
        return !Closeable.class.isAssignableFrom(sourceClass);
    }

    protected Object cloneArray(Object source, Class<?> sourceClass, boolean finalImmutable, Map<Object, Object> instanceMap) {
        if (instanceMap.containsKey(source)) {
            return instanceMap.get(source);
        }
        int length = Array.getLength(source);
        Object destination = Array.newInstance(sourceClass, length);
        instanceMap.put(source, destination);
        if (finalImmutable) {
            System.arraycopy(source, 0, destination, 0, length);
        } else {
            for (int i = 0; i < length; ++i) {
                Object component = Array.get(source, i);
                Array.set(destination, i, this.cloneBean(component, instanceMap));
            }
        }
        return destination;
    }

    protected <T> Collection<T> cloneCollection(Collection<T> collection, Map<Object, Object> instanceMap) {
        if (instanceMap.containsKey(collection)) {
            return (Collection)instanceMap.get(collection);
        }
        Collection<T> destination = this.createCollection(collection);
        instanceMap.put(collection, destination);
        for (T sourceItem : collection) {
            destination.add(this.cloneBean(sourceItem, instanceMap));
        }
        return destination;
    }

    protected <T, R> Map<T, R> cloneMap(Map<T, R> map, Map<Object, Object> instanceMap) {
        if (instanceMap.containsKey(map)) {
            return (Map)instanceMap.get(map);
        }
        Map<T, R> destination = this.createMap(map);
        instanceMap.put(map, destination);
        for (T sourceKey : map.keySet()) {
            R sourceItem = map.get(sourceKey);
            destination.put(sourceKey, this.cloneBean(sourceItem, instanceMap));
        }
        return destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertyInfo[] getPropertyInfos(Class<?> sourceClass) {
        PropertyInfo[] propertyInfos = PROPERTIES_CACHE.get(sourceClass);
        if (propertyInfos == null) {
            Object object = PROPERTIES_CACHE_LOCK;
            synchronized (object) {
                try {
                    propertyInfos = PROPERTIES_CACHE.get(sourceClass);
                    if (propertyInfos == null) {
                        List<PropertyInfo> propertyInfoList = this.reflectionHelper.createPropertyInfos(sourceClass);
                        propertyInfos = propertyInfoList.toArray(new PropertyInfo[propertyInfoList.size()]);
                        PROPERTIES_CACHE.put(sourceClass, propertyInfos);
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException("Can not create property infos", ex);
                }
            }
        }
        return propertyInfos;
    }
}

