/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.habitat.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.iworkz.habitat.dao.ConnectionProvider;
import org.iworkz.habitat.dao.GenericDao;
import org.iworkz.habitat.dao.Session;
import org.iworkz.habitat.dialect.DatabaseDialect;
import org.iworkz.habitat.entity.EntityDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DatabaseHelper {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseHelper.class);
    @Inject
    private DatabaseDialect databaseDialect;

    public void dropTableIfExists(ConnectionProvider task, GenericDao dao) {
        this.dropTableIfExists(dao.getEntityDefinition(), task.get());
    }

    public void dropTableIfExists(GenericDao dao) {
        this.dropTableIfExists(dao.getEntityDefinition(), dao.getConnection());
    }

    public void dropTableIfExists(EntityDefinition table, Connection connection) {
        String sql = this.databaseDialect.buildDropTableIfExistsStatement(table);
        this.executeStatement(sql, connection);
    }

    public void createTable(ConnectionProvider task, GenericDao dao) {
        this.createTable(dao.getEntityDefinition(), task.get(), false);
    }

    public void createTable(GenericDao dao) {
        this.createTable(dao.getEntityDefinition(), dao.getConnection(), false);
    }

    public void createTableIfNotExists(Session session, GenericDao dao) {
        this.createTable(dao.getEntityDefinition(), session.getConnection(), true);
    }

    public void createTableIfNotExists(GenericDao dao) {
        this.createTable(dao.getEntityDefinition(), dao.getConnection(), true);
    }

    protected void createTable(EntityDefinition table, Connection connection, boolean onlyIfNotExists) {
        String sql = this.databaseDialect.buildCreateTableIfExistsStatement(table, onlyIfNotExists);
        this.executeStatement(sql, connection);
    }

    public void executeStatement(Session session, String sqlCommand, GenericDao dao) {
        this.executeStatement(sqlCommand, session.getConnection());
    }

    public void executeStatement(String sqlCommand, GenericDao dao) {
        this.executeStatement(sqlCommand, dao.getConnection());
    }

    public void executeStatement(String createTableSQL, Connection connection) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(createTableSQL);
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Can not execute statement", e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception ex) {
                    logger.error("Prepared statement can not be closed", (Throwable)ex);
                }
            }
        }
    }
}

