/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.genesis;

import java.util.ArrayList;
import java.util.ServiceLoader;
import org.iworkz.genesis.Injector;
import org.iworkz.genesis.Module;
import org.iworkz.genesis.impl.DefaultInjectorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface InjectorFactory {
    public static Injector createInjector(Module ... modules) {
        InjectorFactory injectorFactory;
        Logger logger = LoggerFactory.getLogger(InjectorFactory.class);
        ServiceLoader<InjectorFactory> serviceLoader = ServiceLoader.load(InjectorFactory.class);
        ArrayList<InjectorFactory> injectorFactoryList = new ArrayList<InjectorFactory>();
        for (InjectorFactory provider : serviceLoader) {
            injectorFactoryList.add(provider);
        }
        if (injectorFactoryList.size() > 0) {
            injectorFactory = (InjectorFactory)injectorFactoryList.get(0);
            logger.info("Injector factory loaded by ServiceLoader: " + injectorFactory.getClass().getCanonicalName());
        } else {
            logger.info("Default injector factory created: " + DefaultInjectorFactory.class.getCanonicalName());
            injectorFactory = new DefaultInjectorFactory();
        }
        injectorFactory.registerModules(modules);
        return injectorFactory.getInjector();
    }

    public void registerModules(Module ... var1);

    public Injector getInjector();
}

