/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.genesis.impl;

import org.iworkz.genesis.Injector;
import org.iworkz.genesis.Module;
import org.iworkz.genesis.impl.AbstractInjectorFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractBundleInjectorFactory
extends AbstractInjectorFactory {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBundleInjectorFactory.class);
    protected ServiceRegistration<Injector> injectorRegistration;

    @Override
    protected void updateInjector() {
        super.updateInjector();
        this.unregisterInjector();
        this.registerInjector();
    }

    protected void unregisterInjector() {
        if (this.injectorRegistration != null) {
            this.injectorRegistration.unregister();
            this.injectorRegistration = null;
        }
    }

    protected void registerInjector() {
        if (this.registeredModules != null) {
            for (Module module : this.registeredModules) {
                logger.debug("Registered module " + module.getClass().getCanonicalName());
            }
        }
        ServiceFactory<Injector> injectorServiceFactory = new ServiceFactory<Injector>(){

            public Injector getService(Bundle bundle, ServiceRegistration<Injector> registration) {
                return AbstractBundleInjectorFactory.this.getInjector(bundle, registration);
            }

            public void ungetService(Bundle bundle, ServiceRegistration<Injector> registration, Injector injector) {
                AbstractBundleInjectorFactory.this.ungetInjector(bundle, registration, injector);
            }
        };
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        this.injectorRegistration = context.registerService(Injector.class, (ServiceFactory)injectorServiceFactory, null);
    }

    protected Injector getInjector(Bundle bundle, ServiceRegistration<Injector> registration) {
        return this.getInjector();
    }

    protected void ungetInjector(Bundle bundle, ServiceRegistration<Injector> registration, Injector injector) {
    }
}

