/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.genesis.impl.scope;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.iworkz.genesis.ImplementationClassProcessor;
import org.iworkz.genesis.impl.Supplier;
import org.iworkz.genesis.impl.scope.NoScope;

public class ScopeContext {
    private final ThreadLocal<Map<Class<?>, Supplier<?>>> suppliers = new ThreadLocal();
    private Set<ImplementationClassProcessor> implementationClassProcessors;

    public void enter() {
        if (this.suppliers.get() != null) {
            throw new RuntimeException("A scoping block is already in progress");
        }
        this.suppliers.set(new HashMap());
    }

    public void exit() {
        if (this.suppliers.get() == null) {
            throw new RuntimeException("No scoping block in progress");
        }
        this.suppliers.remove();
    }

    public <T> Supplier<T> get(Class<T> injectedClass, Supplier<T> unscoped, Set<ImplementationClassProcessor> implementationClassProcessors) {
        Map<Class<T>, Supplier<T>> scopedSuppliersMap = this.getScopedSuppliersMap(injectedClass);
        Supplier<T> scopedSupplier = scopedSuppliersMap.get(injectedClass);
        if (scopedSupplier == null) {
            scopedSupplier = new Supplier<T>(unscoped, true);
            scopedSupplier.setImplementationClassProcessors(implementationClassProcessors);
            scopedSuppliersMap.put(injectedClass, scopedSupplier);
        }
        return scopedSupplier;
    }

    public <T> void seed(Class<? super T> injectedClass, T value) {
        Map<Class<T>, Supplier<T>> scopedObjects = this.getScopedSuppliersMap(injectedClass);
        if (scopedObjects.containsKey(injectedClass)) {
            throw new RuntimeException("A value for the key " + injectedClass.getCanonicalName() + " was already seeded in this scope: '" + scopedObjects.get(injectedClass) + "'");
        }
        scopedObjects.put(injectedClass, new Supplier<T>(injectedClass, value.getClass(), value, null, NoScope.class));
    }

    protected <T> Map<Class<?>, Supplier<?>> getScopedSuppliersMap(Class<?> injectedClass) {
        Map<Class<?>, Supplier<?>> scopedSuppliersMap = this.suppliers.get();
        if (scopedSuppliersMap == null) {
            throw new RuntimeException("Cannot access " + injectedClass + " outside of a scoping block");
        }
        return scopedSuppliersMap;
    }
}

