/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.habitat.command;

import java.beans.PropertyDescriptor;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.iworkz.common.helper.ReflectionHelper;
import org.iworkz.habitat.command.CommandMetaData;
import org.iworkz.habitat.dao.BlobHelper;
import org.iworkz.habitat.dao.FieldNavigator;
import org.iworkz.habitat.dao.GenericDao;
import org.iworkz.habitat.entity.EntityDefinition;
import org.iworkz.habitat.entity.EntityFieldDefinition;

@Singleton
public class CommandHelper {
    @Inject
    protected ReflectionHelper reflectionHelper;

    public void applyTempFieldValues(Object record, Map<CommandMetaData.ObjectMetaData, Object> initializedFieldValues) throws Exception {
        if (initializedFieldValues != null) {
            for (CommandMetaData.ObjectMetaData fn : initializedFieldValues.keySet()) {
                fn.getWriteMethod().invoke(record, initializedFieldValues.get(fn));
            }
        }
    }

    public void setParameter(PreparedStatement preparedStatement, int index, Object parameter) throws Exception {
        if (parameter == null) {
            throw new RuntimeException("Parameter must not be null");
        }
        if (parameter instanceof Integer) {
            preparedStatement.setInt(index, (Integer)parameter);
        } else if (parameter instanceof String) {
            preparedStatement.setString(index, (String)parameter);
        } else if (parameter instanceof Long) {
            preparedStatement.setLong(index, (Long)parameter);
        } else {
            throw new RuntimeException("Unsupported type of parameter '" + parameter.getClass().getSimpleName() + "'");
        }
    }

    public <T> T readFieldsFromResultSet(T obj, CommandMetaData.ObjectMetaData[] objectMetaData, ResultSet resultSet, FieldNavigator index) throws Exception {
        for (int i = 0; i < objectMetaData.length; ++i) {
            Class<OutputStream> type = objectMetaData[i].getType();
            Method writeMethod = objectMetaData[i].getWriteMethod();
            Object value = this.readValueFromResultSet(resultSet, index.next(), type);
            if (type.isAssignableFrom(OutputStream.class)) {
                OutputStream outputStream = (OutputStream)objectMetaData[i].getReadMethod().invoke(obj, new Object[0]);
                BlobHelper.writeBlobToOutputStream((Blob)value, outputStream);
                continue;
            }
            writeMethod.invoke(obj, value);
        }
        return obj;
    }

    public Object readValueFromResultSet(ResultSet resultSet, int index, Class<? extends Object> fieldClass) throws Exception {
        if (fieldClass == String.class) {
            return resultSet.getString(index);
        }
        if (fieldClass == Integer.class) {
            return resultSet.getInt(index);
        }
        if (fieldClass == Date.class) {
            return resultSet.getDate(index);
        }
        if (fieldClass == Timestamp.class) {
            return resultSet.getTimestamp(index);
        }
        if (fieldClass == BigDecimal.class) {
            return resultSet.getBigDecimal(index);
        }
        if (fieldClass == byte[].class) {
            Blob blob = resultSet.getBlob(index);
            if (blob != null) {
                return blob.getBytes(0L, (int)blob.length());
            }
            return null;
        }
        if (fieldClass.isAssignableFrom(OutputStream.class)) {
            return resultSet.getBlob(index);
        }
        throw new RuntimeException("Unsupported field type '" + fieldClass.getSimpleName() + "'");
    }

    public void writeUpdateParameter(PreparedStatement statement, FieldNavigator index, Object obj, CommandMetaData commandMetaData) throws Exception {
        Object value;
        for (CommandMetaData.ObjectMetaData f : commandMetaData.getPrimaryKeyMetaData()) {
            value = f.getReadMethod().invoke(obj, new Object[0]);
            statement.setObject(index.next(), value);
        }
        for (CommandMetaData.ObjectMetaData f : commandMetaData.getVersionMetaData()) {
            value = f.getReadMethod().invoke(obj, new Object[0]);
            statement.setObject(index.next(), value);
        }
    }

    protected void writeRecordToPreparedStatement(PreparedStatement statement, FieldNavigator index, Object obj, CommandMetaData commandMetaData, Map<CommandMetaData.ObjectMetaData, Object> tempFieldValues, GenericDao.CommandCustomizer statementAdapter, boolean isNewRecord) throws Exception {
        for (CommandMetaData.ObjectMetaData objectMetaData : commandMetaData.getObjectMetaData()) {
            boolean hasCustomValue;
            EntityFieldDefinition dbField = objectMetaData.getDatabaseField();
            boolean bl = hasCustomValue = statementAdapter != null && statementAdapter.customValue(dbField.getName()) != null;
            if (hasCustomValue) continue;
            Object value = tempFieldValues != null && (dbField.isVersionField() || isNewRecord && dbField.isPrimaryKeyField()) ? tempFieldValues.get(objectMetaData) : objectMetaData.getReadMethod().invoke(obj, new Object[0]);
            statement.setObject(index.next(), value);
        }
    }

    protected <T> PropertyDescriptor[] createPropertyDescriptorsForClass(EntityDefinition entityDefinition, Class<T> objectClass, GenericDao.CommandCustomizer statementAdapter, ResultSet rs) {
        Field[] objectClassFields = this.reflectionHelper.getAllFields(objectClass);
        ArrayList<PropertyDescriptor> fieldList = new ArrayList<PropertyDescriptor>();
        try {
            if (rs != null) {
                ResultSetMetaData metaData = rs.getMetaData();
                for (int i = 0; i < metaData.getColumnCount(); ++i) {
                    String tableName;
                    String recordFieldName = metaData.getColumnLabel(i + 1);
                    String propertyName = entityDefinition.fieldNameForColumn(recordFieldName, tableName = metaData.getTableName(i + 1));
                    Field recordField = entityDefinition.findField(objectClassFields, propertyName);
                    if (recordField == null) {
                        boolean isAdditionalColumn = false;
                        if (statementAdapter != null) {
                            for (String cn : statementAdapter.customColumns()) {
                                if (!recordFieldName.equalsIgnoreCase(cn)) continue;
                                isAdditionalColumn = true;
                                break;
                            }
                        }
                        if (!isAdditionalColumn) {
                            throw new RuntimeException("Property not found in bean '" + objectClass.getName() + "'. Expected property for field '" + recordFieldName + "' is '" + propertyName + "'");
                        }
                    }
                    if (recordField == null) continue;
                    PropertyDescriptor propertyDescriptor = new PropertyDescriptor(recordField.getName(), objectClass);
                    fieldList.add(propertyDescriptor);
                }
            } else {
                for (EntityFieldDefinition dbField : entityDefinition.getFields()) {
                    String tableName;
                    String recordFieldName = dbField.getName();
                    String propertyName = entityDefinition.fieldNameForColumn(recordFieldName, tableName = entityDefinition.getName());
                    Field recordField = entityDefinition.findField(objectClassFields, propertyName);
                    if (recordField == null) continue;
                    PropertyDescriptor propertyDescriptor = new PropertyDescriptor(propertyName, objectClass);
                    fieldList.add(propertyDescriptor);
                }
            }
            PropertyDescriptor[] resultSetFields = new PropertyDescriptor[fieldList.size()];
            fieldList.toArray(resultSetFields);
            return resultSetFields;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can not create descriptor for class " + objectClass.getCanonicalName(), ex);
        }
    }
}

