package org.iworkz.habitat.dao;

import javax.sql.DataSource;

abstract public class AbstractDataSourceProvider {
	
	private final DataSource dataSource;
	
	public AbstractDataSourceProvider(Object options) {	
		dataSource = createDataSource(options);	
	}
	
	public DataSource getDataSource() {
		return dataSource;
	}
	
	abstract protected DataSource createDataSource(Object options);

}
