package org.iworkz.habitat.dao;

import javax.inject.Inject;
import javax.inject.Singleton;


@Singleton
public class ContextAccess {
	
	private final ThreadLocal<Context> context= new ThreadLocal<Context>() {	
	    @Override 
	    protected Context initialValue() {
	    	return createContext();
	    }
	};
	
	@Inject
	protected AbstractDataSourceProvider dataSourceProvider;
	
	public Context getContext() {
		return context.get();
	}
	
	public void startContext() {
		context.get().start();
	}
	
	public void closeContext() {
		context.get().close();
		context.remove();
	}
	
	protected Context createContext() {
		Context ctx = new Context(dataSourceProvider.getDataSource());
        return ctx;
	}


}
