package org.iworkz.habitat.entity;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.sql.Blob;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Version;

import org.iworkz.habitat.dao.EntityDao;
import org.iworkz.habitat.dao.FieldType;
import org.iworkz.habitat.helper.ReflectionHelper;

@Singleton
public class EntityDefinitionCreator {

	@Inject
    protected ReflectionHelper reflectionHelper; // = new ReflectionHelper();
	
    
    public EntityDefinition readEntityDefinition(Class<?extends EntityDao> daoClass) {
        Class<?>classWithEntityAnnotation = getClassWithEntityAnnotation(daoClass);
        if (classWithEntityAnnotation == null) {
            throw new RuntimeException("The record class is not defined");
        }
        // create table definition from annotated recordClass
        Entity entityAnnotation = classWithEntityAnnotation.getAnnotation(Entity.class);
        if (entityAnnotation.name() == null) {
            throw new RuntimeException("The name of the entity annotation is not defined");
        }
        EntityDefinition entityDefinition = new EntityDefinition(entityAnnotation.name(),reflectionHelper);
        Field[] recordClassFields = reflectionHelper.getAllFields(classWithEntityAnnotation);
        for (Field field : recordClassFields) {
            Column columnAnnotation = field.getAnnotation(Column.class);
            if (columnAnnotation != null) {
                String columnName = columnAnnotation.name();
                FieldType columnType = columnTypeForType(field.getGenericType());
                Integer constraint1=columnAnnotation.length();
                Boolean nullable = !columnAnnotation.nullable();
                EntityFieldDefinition column = new EntityFieldDefinition(columnName,field.getName(),columnType,constraint1,nullable);
                entityDefinition.addField(column);
            }
            Id idAnnotation = field.getAnnotation(Id.class);
            if (idAnnotation != null) {
                entityDefinition.setPrimaryKey(columnAnnotation.name());
            }
            Version versionAnnotation = field.getAnnotation(Version.class);
            if (versionAnnotation != null) {
                entityDefinition.setVersion(columnAnnotation.name());
            }
        }
        return entityDefinition;
    }
    
    protected Class<?> getClassWithEntityAnnotation(Class<?extends EntityDao> daoClass) {
        Class<?>[] innerClasses = daoClass.getDeclaredClasses();
        for (Class<?> c : innerClasses) {
            Entity entityAnnotation = c.getAnnotation(Entity.class);
            if (entityAnnotation != null) {
                return c;
            }
        }
        throw new RuntimeException("Entity class not found");
    }
    
    protected FieldType columnTypeForType(Type type) {
        if (type == String.class) {
            return FieldType.VARCHAR;
        } else if (type == Integer.class) {
            return FieldType.NUMBER;
        } else if (type == Blob.class) {
            return FieldType.BLOB;
        }
        return FieldType.VARCHAR;
    }

}
