/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.habitat.dao;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.iworkz.habitat.dao.AbstractDataSourceProvider;
import org.iworkz.habitat.dao.Context;

@Singleton
public class ContextAccess {
    private final ThreadLocal<Context> context = new ThreadLocal<Context>(){

        @Override
        protected Context initialValue() {
            return ContextAccess.this.createContext();
        }
    };
    @Inject
    protected AbstractDataSourceProvider dataSourceProvider;

    public Context getContext() {
        return this.context.get();
    }

    public void startContext() {
        this.context.get().start();
    }

    public void closeContext() {
        this.context.get().close();
        this.context.remove();
    }

    protected Context createContext() {
        Context ctx = new Context(this.dataSourceProvider.getDataSource());
        return ctx;
    }
}

