package org.iworkz.habitat.command;

import javax.inject.Singleton;

import org.iworkz.habitat.dao.GenericDao.CommandCustomizer;
import org.iworkz.habitat.entity.EntityDefinition;

@Singleton
public class CommandBuilder {
    
    public<T> String buildInsertCommand(EntityDefinition entityDefinition, Class<T> objectClass) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("INSERT INTO "+entityDefinition.getName()+" (");
        entityDefinition.appendFieldSql(buffer,objectClass,true);
        buffer.append(") VALUES (");
        entityDefinition.appendFieldQuestionmarksSql(buffer,objectClass);
        buffer.append(")");
        return buffer.toString();
    }
    
    public<T> String buildUpdateCommand(EntityDefinition entityDefinition, Class<T> objectClass, CommandCustomizer statementAdapter) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("UPDATE "+entityDefinition.getName()+" SET ");
        entityDefinition.appendFieldAssigmentSql(buffer,objectClass,true);
        if (statementAdapter != null) {
            entityDefinition.appendAdditionalFieldAssigmentSql(buffer,statementAdapter.customColumns());
        }
        buffer.append(" WHERE ");
        entityDefinition.appendPrimaryKeyCriteriaSql(buffer);
        entityDefinition.appendVersionCriteriaSql(buffer);
        return buffer.toString();
    }
    
    public<T> String buildDeleteCommand(EntityDefinition entityDefinition) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("DELETE "+entityDefinition.getName());
        buffer.append(" WHERE ");
        entityDefinition.appendPrimaryKeyCriteriaSql(buffer);
         return buffer.toString();
    }
    
    public<T> String buildDeleteObjectCommand(EntityDefinition entityDefinition) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("DELETE "+entityDefinition.getName());
        buffer.append(" WHERE ");
        entityDefinition.appendPrimaryKeyCriteriaSql(buffer);
        entityDefinition.appendVersionCriteriaSql(buffer);
        return buffer.toString();
    }
    
    public<T> String buildDeleteWhereCommand(EntityDefinition entityDefinition, String criteriaString) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("DELETE "+entityDefinition.getName());
        if (criteriaString != null) {
            buffer.append(" WHERE "+criteriaString);
        }
        return buffer.toString();
    }
    
    public<T> String buildLoadCommand(EntityDefinition entityDefinition, Class<T> objectClass, CommandCustomizer statementAdapter) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SELECT ");
        entityDefinition.appendFieldSql(buffer,objectClass,true);
        if (statementAdapter != null) {
            entityDefinition.appendAdditionalColumns(buffer,statementAdapter.customColumns());
        }
        buffer.append(" FROM "+entityDefinition.getName());
        buffer.append(" WHERE ");
        entityDefinition.appendPrimaryKeyCriteriaSql(buffer);
        return buffer.toString();
    }
    
    public<T> String buildFindCommand(EntityDefinition entityDefinition, Class<T> objectClass, CommandCustomizer statementAdapter, String criteriaString, String orderByString, boolean paging) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SELECT ");
        entityDefinition.appendFieldSql(buffer,objectClass,true);
        buffer.append(" FROM "+entityDefinition.getName());
        if (criteriaString != null) {
            buffer.append(" WHERE "+criteriaString);
        }
        if (orderByString != null) {
            buffer.append(" ORDER BY "+orderByString);
        }
        if (paging) {
            buffer.append(" OFFSET ? LIMIT ?");
        }
        return buffer.toString();
    }

        

}
