package org.iworkz.habitat.command;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import org.iworkz.habitat.dao.GenericDao;
import org.iworkz.habitat.dao.GenericDao.CommandCustomizer;
import org.iworkz.habitat.entity.EntityDefinition;
import org.iworkz.habitat.entity.EntityFieldDefinition;



public class CommandMetaData {
	
	private final EntityDefinition table;

	private String command;
	
	int totalFieldCount;
	
	ObjectMetaData[] objectMetaData;
	ObjectMetaData[] primaryKeyMetaData;
	ObjectMetaData[] versionMetaData;
	
	public CommandMetaData(EntityDefinition table) {
		this.table = table;
	}

	public String getCommand() {
		return command;
	}

	public void setCommand(String command) {
		this.command = command;
	}
	
	public ObjectMetaData[] getObjectMetaData() {
		return objectMetaData;
	}

	public void setPropertyDescriptors(PropertyDescriptor[] resultSetFields, CommandCustomizer statementAdapter) {
		List<ObjectMetaData> primaryKeyList = new ArrayList<ObjectMetaData>();
		List<ObjectMetaData> versionList = new ArrayList<ObjectMetaData>();
		objectMetaData = new ObjectMetaData[resultSetFields.length];
		for (int i=0;i<resultSetFields.length;i++) {
			PropertyDescriptor propertyDescriptor = resultSetFields[i];
			objectMetaData[i] = new ObjectMetaData();
			objectMetaData[i].objectProperty = propertyDescriptor;
			objectMetaData[i].type = propertyDescriptor.getPropertyType();
			objectMetaData[i].writeMethod = propertyDescriptor.getWriteMethod();
			objectMetaData[i].readMethod = propertyDescriptor.getReadMethod();
			objectMetaData[i].databaseField = table.getDatabaseFieldForObjectFieldName(propertyDescriptor.getName());
			if (objectMetaData[i].databaseField.isPrimaryKeyField()) {
				primaryKeyList.add(objectMetaData[i]);
			}
			if (objectMetaData[i].databaseField.isVersionField()) {
				versionList.add(objectMetaData[i]);
			}
		}
		primaryKeyMetaData = new ObjectMetaData[primaryKeyList.size()];
		primaryKeyList.toArray(primaryKeyMetaData);
		versionMetaData = new ObjectMetaData[versionList.size()];
		versionList.toArray(versionMetaData);
		totalFieldCount = objectMetaData.length;
		if (statementAdapter != null && statementAdapter.customColumns() != null) {
			totalFieldCount += statementAdapter.customColumns().length;
		}
	}
	
	
	
	public int getTotalFieldCount() {
        return totalFieldCount;
    }

    public ObjectMetaData[] getPrimaryKeyMetaData() {
        return primaryKeyMetaData;
    }

    public ObjectMetaData[] getVersionMetaData() {
        return versionMetaData;
    }



    static public class ObjectMetaData {
		
		PropertyDescriptor objectProperty;
		Method writeMethod;
		Method readMethod;
		Class<?> type;
		EntityFieldDefinition databaseField;
		
		@Override
		public int hashCode(){
			return this.objectProperty.hashCode();	
		}
		
		@Override
		public boolean equals(Object obj) {
		    if (!(obj instanceof ObjectMetaData)) {
		    	return false;
		    }
		    return ((ObjectMetaData)obj).objectProperty.equals(obj);
	    }

        public Class<?> getType() {
            return type;
        }

        public PropertyDescriptor getObjectProperty() {
            return objectProperty;
        }

        public Method getWriteMethod() {
            return writeMethod;
        }

        public Method getReadMethod() {
            return readMethod;
        }

        public EntityFieldDefinition getDatabaseField() {
            return databaseField;
        }
        
        
		
		
	}

}
