package org.iworkz.habitat.dao;

import javax.inject.Inject;
import javax.inject.Singleton;

import org.iworkz.habitat.entity.EntityDefinition;
import org.iworkz.habitat.entity.EntityDefinitionCreator;


@Singleton
abstract public class EntityDao {
    
    private EntityDefinition entityDefinition;
    
    @Inject
    protected EntityDefinitionCreator entityDefinitionCreator;
    
    
    public EntityDefinition getEntityDefinition() {
        if (entityDefinition == null) {
            entityDefinition = createEntityDefinition();
        }
        return entityDefinition;
    }
    
    protected EntityDefinition createEntityDefinition() {
        return entityDefinitionCreator.readEntityDefinition(getClass());
    }

}
