package org.iworkz.habitat.helper;

import java.util.LinkedHashMap;
import java.util.Map;

import javax.inject.Singleton;

import org.iworkz.habitat.command.CommandMetaData;
import org.iworkz.habitat.command.CommandMetaData.ObjectMetaData;
import org.iworkz.habitat.dao.IdGenerator;


@Singleton
public class RecordHelper {
    
    public Map<ObjectMetaData,Object> initializeNewRecord(Object record, CommandMetaData commandMetaData, IdGenerator<?> idGenerator) throws Exception {
        Map<ObjectMetaData,Object> initializedFieldValues = new LinkedHashMap<ObjectMetaData,Object>();
        initializePrimaryKeyOfRecord(record, commandMetaData,initializedFieldValues,idGenerator);
        initializeVersionOfRecord(record, commandMetaData,initializedFieldValues);
        return initializedFieldValues;
    }
    
    protected void initializePrimaryKeyOfRecord(Object record, CommandMetaData commandMetaData, Map<ObjectMetaData,Object> initializedFieldValues, IdGenerator<?> idGenerator) throws Exception {
        for (ObjectMetaData f : commandMetaData.getPrimaryKeyMetaData()) {
            if (f.getType() == String.class) {
                String nextID = (String)generateId(idGenerator);   
                initializedFieldValues.put(f, nextID);
            } else {
                throw new RuntimeException("Unsupported type for primary key field: "+f.getType());
            }
        }
    }
    
    protected Object generateId(IdGenerator<?> idGenerator) {     
        return idGenerator.nextId(null);
    }
    
    protected void initializeVersionOfRecord(Object record, CommandMetaData commandMetaData, Map<ObjectMetaData,Object> initializedFieldValues) throws Exception {
        for (ObjectMetaData f : commandMetaData.getVersionMetaData()) {
            if (f.getType() == Integer.class) {
                Integer initialVersion = 1;
                initializedFieldValues.put(f, initialVersion);
            } else {    
                throw new RuntimeException("Unsupported type for version field"+f.getType());
            }
        }
    }
    
    public Map<ObjectMetaData,Object> createUpdatedVersionInfo(Object record, CommandMetaData commandMetaData) throws Exception {    
        Map<ObjectMetaData,Object> updatedVersionInfo = null;
        for (ObjectMetaData f : commandMetaData.getVersionMetaData()) {
            Object currentVersion = f.getReadMethod().invoke(record);
            if (currentVersion == null) {
                throw new RuntimeException("The version field must not be null (version field name in database = '"+f.getDatabaseField().getName()+"')");
            }
            if (currentVersion instanceof Integer) {
                Integer newVersion = ((Integer)currentVersion)+1;
                if (updatedVersionInfo == null) {
                    updatedVersionInfo = new LinkedHashMap<ObjectMetaData,Object>();
                    updatedVersionInfo.put(f, newVersion);
                }
            } else {    
                throw new RuntimeException("Unsupported type for version field");
            }
        }
        return updatedVersionInfo;
    }

}
