package org.iworkz.provenience;

import java.lang.reflect.Constructor;
import java.util.Stack;

import javax.inject.Inject;
import javax.inject.Singleton;

public class Provider<T> {
	
	final protected Class<T> injectedClass;
	protected Class<? extends T> implementationClass;
	protected boolean singleton;
	protected T instance;
	
	@SuppressWarnings("unchecked")
	public Provider(T instance) {
		this((Class<T>)instance.getClass(),(Class<? extends T>)instance.getClass(),instance);
	}
	
	@SuppressWarnings("unchecked")
	public Provider(Class<T> injectedClass, Class<? extends T> implementationClass, Object instance) {
		this.injectedClass = injectedClass;
		this.instance = (T)instance;
		if (instance != null) {
			this.implementationClass = (Class<? extends T>)instance.getClass();
		} else {
			this.implementationClass = implementationClass;
		}
		if (implementationClass != null) {
			singleton = implementationClass.isAnnotationPresent(Singleton.class);
		}
	}
	
	public Object getInstance(Injector injector, Stack<Class<?>> creationStack) {
		if (instance != null) {
			return instance;
		}
		creationStack.push(injectedClass);
		T newInstance = (T)createInstance(injector,creationStack);
		if (singleton) {
			instance = newInstance;
		}
		creationStack.pop();
		injector.injectMembers(newInstance,newInstance.getClass(),creationStack);
		if (newInstance instanceof Initializeable) {
			Initializeable inititializeable = (Initializeable)newInstance;
			inititializeable.initialize();
		}
		return newInstance;
	}

	public T createInstance(Injector injector, Stack<Class<?>> creationStack) {
		if (implementationClass == null) {
			throw new IllegalArgumentException("The implementation class must be defined");
		}
		try {
			Constructor<? extends T> constructor = getConstructor(implementationClass);
			if (constructor != null) {
				constructor.setAccessible(true);
				if (constructor.getParameterCount() > 0) {
					Class<?>[] parameterTypes = constructor.getParameterTypes();
					Object[] initargs = new Object[parameterTypes.length];
					for (int i=0;i<parameterTypes.length;i++) {
						initargs[i] = injector.get(parameterTypes[i],creationStack);
					}
					return constructor.newInstance(initargs);
				} else {
					return constructor.newInstance();
				}
			} else {
				throw new RuntimeException("No suitable constructor found for injection");
			}
		} catch (Exception e) {
			throw new RuntimeException("Can not create singleton for class '"+implementationClass.getCanonicalName()+"'",e);
		}
	}
	
	@SuppressWarnings("unchecked")
	public Constructor<? extends T> getConstructor(Class<? extends T> implementationClass) {
		Constructor<?> d = null;
		for (Constructor<?> c : implementationClass.getDeclaredConstructors()) {
			if (c.isAnnotationPresent(Inject.class)) {
				return (Constructor<? extends T>) c;
			}
			if (c.getParameterCount() == 0) {
				d = c;
			}
		}
		return (Constructor<? extends T>) d;
	}

}
