/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.habitat.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.inject.Singleton;
import org.iworkz.habitat.dao.GenericDao;
import org.iworkz.habitat.entity.EntityDefinition;

@Singleton
public class DatabaseHelper {
    public void dropTableIfExists(GenericDao dao) {
        this.dropTableIfExists(dao.getEntityDefinition(), dao.getConnection());
    }

    public void dropTableIfExists(EntityDefinition table, Connection connection) {
        String sql = "DROP TABLE IF EXISTS " + table.getName() + ";";
        this.executeStatement(sql, connection);
    }

    public void createTable(GenericDao dao) {
        this.createTable(dao.getEntityDefinition(), dao.getConnection(), false);
    }

    public void createTableIfNotExists(GenericDao dao) {
        this.createTable(dao.getEntityDefinition(), dao.getConnection(), true);
    }

    protected void createTable(EntityDefinition table, Connection connection, boolean onlyIfNotExists) {
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE ");
        if (onlyIfNotExists) {
            sql.append("IF NOT EXISTS ");
        }
        sql.append(table.getName() + "(");
        table.appendFieldDefinitionsSql(sql);
        table.appendPrimaryKeySqL(sql);
        sql.append(")");
        this.executeStatement(sql.toString(), connection);
    }

    public void executeStatement(String sqlCommand, GenericDao dao) {
        this.executeStatement(sqlCommand, dao.getConnection());
    }

    public void executeStatement(String createTableSQL, Connection connection) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(createTableSQL);
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Can not execute statement", e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

