/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.habitat.helper;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.iworkz.habitat.helper.ReflectionHelper;

@Singleton
public class BeanHelper {
    @Inject
    protected ReflectionHelper reflectionHelper;

    public <T> T cloneBean(T source) {
        HashMap<Object, Object> cloneStack = new HashMap<Object, Object>();
        return this.cloneBean(source, cloneStack);
    }

    protected <T> T cloneBean(T source, Map<Object, Object> cloneMap) {
        if (source != null) {
            if (cloneMap.containsKey(this)) {
                return (T)cloneMap.get(this);
            }
            Object destination = this.reflectionHelper.createObject(source.getClass());
            this.cloneBean(source, destination, cloneMap);
            cloneMap.put(this, destination);
            return (T)destination;
        }
        return null;
    }

    protected <T> void cloneBean(T source, T destination, Map<Object, Object> cloneMap) {
        if (source != null) {
            if (destination == null) {
                throw new IllegalArgumentException("The destination bean is null");
            }
            try {
                PropertyDescriptor[] propertyDescriptors;
                BeanInfo beanInfo = Introspector.getBeanInfo(source.getClass());
                for (PropertyDescriptor pd : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                    Object value;
                    Method writeMethod;
                    Method readMethod = pd.getReadMethod();
                    if (readMethod == null || (writeMethod = pd.getWriteMethod()) == null || (value = readMethod.invoke(source, new Object[0])) == null) continue;
                    Class<?> valueClass = value.getClass();
                    if (valueClass.isArray()) {
                        writeMethod.invoke(destination, this.cloneArray(value, cloneMap));
                        continue;
                    }
                    if (Collection.class.isAssignableFrom(valueClass)) {
                        writeMethod.invoke(destination, this.cloneCollection((Collection)value, cloneMap));
                        continue;
                    }
                    if (this.shouldClonePropertyOfType(valueClass)) {
                        writeMethod.invoke(destination, this.cloneBean(value, cloneMap));
                        continue;
                    }
                    writeMethod.invoke(destination, value);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Can not clone bean '" + source.getClass().getCanonicalName() + "'", e);
            }
        }
    }

    protected boolean shouldClonePropertyOfType(Class<?> propertyClass) {
        if (propertyClass.isPrimitive()) {
            return false;
        }
        Package propertyPackage = propertyClass.getPackage();
        String packageName = propertyPackage.getName();
        return !packageName.startsWith("java");
    }

    protected Object cloneArray(Object value, Map<Object, Object> cloneMap) {
        Class<?> valueClass = value.getClass().getComponentType();
        int length = Array.getLength(value);
        Object destination = Array.newInstance(valueClass, length);
        if (this.shouldClonePropertyOfType(valueClass)) {
            for (int i = 0; i < length; ++i) {
                Object component = Array.get(value, i);
                Array.set(destination, i, this.cloneBean(component, cloneMap));
            }
        } else {
            System.arraycopy(value, 0, destination, 0, length);
        }
        return destination;
    }

    protected Object cloneCollection(Collection<?> value, Map<Object, Object> cloneMap) {
        Collection destination = (Collection)this.reflectionHelper.createObject(value.getClass());
        for (Object sourceItem : value) {
            Class<?> valueClass = value.getClass();
            if (this.shouldClonePropertyOfType(valueClass)) {
                destination.add(this.cloneBean(sourceItem, cloneMap));
                continue;
            }
            destination.add(sourceItem);
        }
        return destination;
    }
}

