/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.provenience;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.inject.Inject;
import org.iworkz.habitat.helper.ReflectionHelper;
import org.iworkz.provenience.Binding;
import org.iworkz.provenience.Module;
import org.iworkz.provenience.Provider;

public class Injector {
    ReflectionHelper reflectionHelper = new ReflectionHelper();
    protected final Map<Class<?>, Provider<?>> providers;
    protected final Map<Class<?>, Binding<?>> bindings = new HashMap();

    public Injector(Module ... modules) {
        this.providers = new HashMap();
        this.providers.put(Injector.class, new Provider<Injector>(this));
        if (modules != null) {
            for (Module module : modules) {
                module.configure();
                if (module.getBindings() == null) continue;
                for (Class<?> singletonClass : module.getBindings().keySet()) {
                    Binding<?> binding = module.getBindings().get(singletonClass);
                    this.bindings.put(singletonClass, binding);
                }
            }
        }
    }

    public void injectMembers(Object instance) {
        if (instance != null) {
            Stack creationStack = new Stack();
            this.injectMembers(instance, instance.getClass(), creationStack);
        }
    }

    protected void injectMembers(Object instance, Class<?> classWithMembers, Stack<Class<?>> creationStack) {
        for (Field field : this.reflectionHelper.getAllFields(classWithMembers)) {
            Inject injectAnnotation = field.getAnnotation(Inject.class);
            if (injectAnnotation == null) continue;
            try {
                field.setAccessible(true);
                field.set(instance, this.get(field.getType(), creationStack));
            }
            catch (Exception e) {
                throw new RuntimeException("Can not inject field '" + field.getName() + "' of class '" + instance.getClass().getCanonicalName() + "'", e);
            }
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(classWithMembers);
            for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                Method setter = pd.getWriteMethod();
                if (setter == null) continue;
                setter.setAccessible(true);
                if (!setter.isAnnotationPresent(Inject.class)) continue;
                setter.invoke(instance, this.get(setter.getParameterTypes()[0], creationStack));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Can not inject setter of class '" + instance.getClass().getCanonicalName() + "'", e);
        }
    }

    public <T> T get(Class<T> instanceClass) {
        Stack creationStack = new Stack();
        return this.get(instanceClass, creationStack);
    }

    protected <T> T get(Class<T> instanceClass, Stack<Class<?>> creationStack) {
        if (creationStack.contains(instanceClass)) {
            throw new RuntimeException("Circular dependency detected during creation of '" + instanceClass + "', stack = " + creationStack.toString());
        }
        Provider<Object> provider = this.providers.get(instanceClass);
        if (provider == null) {
            Binding<?> binding = this.bindings.get(instanceClass);
            provider = binding != null ? new Provider(instanceClass, binding.implementationClass, binding.getInstance()) : new Provider<T>(instanceClass, instanceClass, null);
            this.providers.put(instanceClass, provider);
        }
        return (T)provider.getInstance(this, creationStack);
    }
}

