package org.iworkz.provenience;

import java.util.HashMap;
import java.util.Map;

public class Module {
	
	private Map<Class<?>,Binding<?>> bindings;
	
	protected void configure() {
	}

	protected <T> Binding<T> bind(Class<T> singletonClass) {
		if (bindings == null) {
			bindings = new HashMap<Class<?>,Binding<?>>();
		}
		Binding<T> bindingBuilder = new Binding<T>(singletonClass);
		bindings.put(singletonClass, bindingBuilder);
		return bindingBuilder;
	}

	public Map<Class<?>, Binding<?>> getBindings() {
		return bindings;
	}

}
