/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.common.helper;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Singleton;

@Singleton
public class ReflectionHelper {
    public <T> Field[] getAllFields(Class<T> objectClass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        this.addAllFields(fields, objectClass);
        return fields.toArray(new Field[fields.size()]);
    }

    protected <T> void addAllFields(List<Field> fields, Class<T> objectClass) {
        fields.addAll(Arrays.asList(objectClass.getDeclaredFields()));
        if (objectClass.getSuperclass() != null) {
            this.addAllFields(fields, objectClass.getSuperclass());
        }
    }

    public <T> T createObject(Class<T> objectClass) {
        try {
            Constructor<T> defaultConstructor = objectClass.getConstructor(new Class[0]);
            T obj = defaultConstructor.newInstance(new Object[0]);
            return obj;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can not create instance for class '" + objectClass.getName() + "'", ex);
        }
    }
}

