/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.habitat.dao;

import java.beans.PropertyDescriptor;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.iworkz.common.helper.CloneHelper;
import org.iworkz.common.helper.ReflectionHelper;
import org.iworkz.habitat.command.CommandBuilder;
import org.iworkz.habitat.command.CommandMetaData;
import org.iworkz.habitat.dao.BlobHelper;
import org.iworkz.habitat.dao.ContextAccess;
import org.iworkz.habitat.dao.EntityDao;
import org.iworkz.habitat.dao.ExceptionFactory;
import org.iworkz.habitat.dao.FieldNavigator;
import org.iworkz.habitat.dao.IdGenerator;
import org.iworkz.habitat.entity.EntityFieldDefinition;
import org.iworkz.habitat.helper.RecordHelper;
import org.iworkz.habitat.helper.StringHelper;

@Singleton
public abstract class GenericDao
extends EntityDao {
    protected final Map<String, CommandMetaData> commandMetaDataMap = new HashMap<String, CommandMetaData>();
    protected IdGenerator<?> idGenerator = this.createIdGenerator();
    protected StringHelper stringHelper = new StringHelper();
    @Inject
    protected ReflectionHelper reflectionHelper;
    @Inject
    RecordHelper recordHelper;
    @Inject
    CommandBuilder commandBuilder;
    @Inject
    protected ContextAccess contextAccess;
    @Inject
    protected ExceptionFactory exceptionFactory;
    @Inject
    CloneHelper beanHelper;

    protected Connection getConnection() {
        return this.contextAccess.getContext().getConnection();
    }

    public abstract IdGenerator createIdGenerator();

    protected synchronized void putCommandMetaData(String name, CommandMetaData commandMetaData) {
        this.commandMetaDataMap.put(name, commandMetaData);
    }

    protected synchronized CommandMetaData getCommandMetaData(String name) {
        return this.commandMetaDataMap.get(name);
    }

    protected void setParameter(PreparedStatement preparedStatement, int index, Object parameter) throws Exception {
        if (parameter == null) {
            throw new RuntimeException("Parameter must not be null");
        }
        if (parameter instanceof Integer) {
            preparedStatement.setInt(index, (Integer)parameter);
        } else if (parameter instanceof String) {
            preparedStatement.setString(index, (String)parameter);
        } else if (parameter instanceof Long) {
            preparedStatement.setLong(index, (Long)parameter);
        } else {
            throw new RuntimeException("Unsupported type of parameter '" + parameter.getClass().getSimpleName() + "'");
        }
    }

    protected void writeRecordToPreparedStatement(PreparedStatement statement, FieldNavigator index, Object obj, CommandMetaData commandMetaData, Map<CommandMetaData.ObjectMetaData, Object> tempFieldValues, boolean isNewRecord) throws Exception {
        for (CommandMetaData.ObjectMetaData objectMetaData : commandMetaData.getObjectMetaData()) {
            EntityFieldDefinition dbField = objectMetaData.getDatabaseField();
            Object value = tempFieldValues != null && (dbField.isVersionField() || isNewRecord && dbField.isPrimaryKeyField()) ? tempFieldValues.get(objectMetaData) : objectMetaData.getReadMethod().invoke(obj, new Object[0]);
            statement.setObject(index.next(), value);
        }
    }

    protected Object readValueFromResultSet(ResultSet resultSet, int index, Class<? extends Object> fieldClass) throws Exception {
        if (fieldClass == String.class) {
            return resultSet.getString(index);
        }
        if (fieldClass == Integer.class) {
            return resultSet.getInt(index);
        }
        if (fieldClass == Date.class) {
            return resultSet.getDate(index);
        }
        if (fieldClass == Timestamp.class) {
            return resultSet.getTimestamp(index);
        }
        if (fieldClass == byte[].class) {
            Blob blob = resultSet.getBlob(index);
            if (blob != null) {
                return blob.getBytes(0L, (int)blob.length());
            }
            return null;
        }
        if (fieldClass.isAssignableFrom(OutputStream.class)) {
            return resultSet.getBlob(index);
        }
        throw new RuntimeException("Unsupported field type '" + fieldClass.getSimpleName() + "'");
    }

    protected <T> T readFieldsFromResultSet(T obj, CommandMetaData.ObjectMetaData[] objectMetaData, ResultSet resultSet, FieldNavigator index) throws Exception {
        for (int i = 0; i < objectMetaData.length; ++i) {
            Class<OutputStream> type = objectMetaData[i].getType();
            Method writeMethod = objectMetaData[i].getWriteMethod();
            Object value = this.readValueFromResultSet(resultSet, index.next(), type);
            if (type.isAssignableFrom(OutputStream.class)) {
                OutputStream outputStream = (OutputStream)objectMetaData[i].getReadMethod().invoke(obj, new Object[0]);
                BlobHelper.writeBlobToOutputStream((Blob)value, outputStream);
                continue;
            }
            writeMethod.invoke(obj, value);
        }
        return obj;
    }

    protected void writeUpdateParameter(PreparedStatement statement, FieldNavigator index, Object obj, CommandMetaData commandMetaData) throws Exception {
        Object value;
        for (CommandMetaData.ObjectMetaData f : commandMetaData.getPrimaryKeyMetaData()) {
            value = f.getReadMethod().invoke(obj, new Object[0]);
            statement.setObject(index.next(), value);
        }
        for (CommandMetaData.ObjectMetaData f : commandMetaData.getVersionMetaData()) {
            value = f.getReadMethod().invoke(obj, new Object[0]);
            statement.setObject(index.next(), value);
        }
    }

    public <T> T insert(T obj) {
        Class<?> objectClass = obj.getClass();
        Connection conn = this.getConnection();
        String name = "_insertObject" + obj.getClass().getName();
        CommandMetaData commandMetaData = this.getCommandMetaData(name);
        if (commandMetaData == null) {
            commandMetaData = new CommandMetaData(this.getEntityDefinition());
            commandMetaData.setCommand(this.commandBuilder.buildInsertCommand(this.getEntityDefinition(), objectClass));
            this.putCommandMetaData(name, commandMetaData);
        }
        String sqlCommand = commandMetaData.getCommand();
        FieldNavigator ii = new FieldNavigator();
        Statement preparedStatement = null;
        try {
            if (commandMetaData.getObjectMetaData() == null) {
                commandMetaData.setPropertyDescriptors(this.createPropertyDescriptorsForClass(objectClass, null, null), null);
            }
            Map<CommandMetaData.ObjectMetaData, Object> tempFieldValues = this.recordHelper.initializeNewRecord(obj, commandMetaData, this.idGenerator);
            preparedStatement = conn.prepareStatement(sqlCommand);
            this.writeRecordToPreparedStatement((PreparedStatement)preparedStatement, ii, obj, commandMetaData, tempFieldValues, true);
            preparedStatement.executeUpdate();
            T persistentObject = this.cloneBean(obj);
            this.applyTempFieldValues(persistentObject, tempFieldValues);
            T t = persistentObject;
            return t;
        }
        catch (Exception e) {
            System.out.println(sqlCommand);
            throw new RuntimeException("Can not insert record in table " + this.getEntityDefinition().getName(), e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    protected <T> T cloneBean(T obj) {
        return this.beanHelper.cloneBean(obj);
    }

    protected void applyTempFieldValues(Object record, Map<CommandMetaData.ObjectMetaData, Object> initializedFieldValues) throws Exception {
        if (initializedFieldValues != null) {
            for (CommandMetaData.ObjectMetaData fn : initializedFieldValues.keySet()) {
                fn.getWriteMethod().invoke(record, initializedFieldValues.get(fn));
            }
        }
    }

    public <T> T update(T obj) {
        return this.update(null, obj);
    }

    public <T> T update(CommandCustomizer statementAdapter, T obj) {
        Connection conn = this.getConnection();
        String name = "_updateObject" + obj.getClass().getName() + statementAdapter;
        CommandMetaData commandMetaData = this.getCommandMetaData(name);
        if (commandMetaData == null) {
            commandMetaData = new CommandMetaData(this.getEntityDefinition());
            commandMetaData.setCommand(this.commandBuilder.buildUpdateCommand(this.getEntityDefinition(), obj.getClass(), statementAdapter));
            this.putCommandMetaData(name, commandMetaData);
        }
        String sqlCommand = commandMetaData.getCommand();
        Statement preparedStatement = null;
        RuntimeException conflictException = null;
        try {
            int res;
            if (commandMetaData.getObjectMetaData() == null) {
                commandMetaData.setPropertyDescriptors(this.createPropertyDescriptorsForClass(obj.getClass(), statementAdapter, null), statementAdapter);
            }
            Map<CommandMetaData.ObjectMetaData, Object> tempFieldValues = this.recordHelper.createUpdatedVersionInfo(obj, commandMetaData);
            preparedStatement = conn.prepareStatement(sqlCommand);
            FieldNavigator ii = new FieldNavigator(commandMetaData.getTotalFieldCount());
            this.writeUpdateParameter((PreparedStatement)preparedStatement, ii, obj, commandMetaData);
            ii.reset();
            this.writeRecordToPreparedStatement((PreparedStatement)preparedStatement, ii, obj, commandMetaData, tempFieldValues, false);
            if (statementAdapter != null) {
                statementAdapter.customSetStatementParameter((PreparedStatement)preparedStatement, ii, obj);
            }
            if ((res = preparedStatement.executeUpdate()) == 0) {
                conflictException = new RuntimeException("Record could not be updated (maybe somebody else updated or deleted it meanwhile)");
                throw conflictException;
            }
            T persistentObject = this.cloneBean(obj);
            this.applyTempFieldValues(persistentObject, tempFieldValues);
            T t = persistentObject;
            return t;
        }
        catch (Exception e) {
            System.out.println(sqlCommand);
            if (e == conflictException) {
                throw this.exceptionFactory.createConflictException("Can not update record in table " + this.getEntityDefinition().getName() + " (maybe somebody else has updated or deleted it meanwhile)");
            }
            throw new RuntimeException("Can not update record in table " + this.getEntityDefinition().getName(), e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void delete(Object ... key) {
        Connection conn = this.getConnection();
        String name = "_deleteObject";
        CommandMetaData commandMetaData = this.getCommandMetaData(name);
        if (commandMetaData == null) {
            commandMetaData = new CommandMetaData(this.getEntityDefinition());
            commandMetaData.setCommand(this.commandBuilder.buildDeleteCommand(this.getEntityDefinition()));
            this.putCommandMetaData(name, commandMetaData);
        }
        String sqlCommand = commandMetaData.getCommand();
        FieldNavigator ii = new FieldNavigator();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = conn.prepareStatement(sqlCommand);
            for (int i = 0; i < key.length; ++i) {
                this.setParameter(preparedStatement, i + 1, key[i]);
            }
            int res = preparedStatement.executeUpdate();
            if (res == 0) {
                throw this.exceptionFactory.createConflictException("Record could not be deleted (maybe somebody else updated or deleted it meanwhile)");
            }
        }
        catch (Exception e) {
            System.out.println(sqlCommand);
            throw new RuntimeException("Can not insert record in table " + this.getEntityDefinition().getName(), e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void deleteObject(Object obj) {
        Connection conn = this.getConnection();
        String name = "_deleteObject";
        CommandMetaData commandMetaData = this.getCommandMetaData(name);
        if (commandMetaData == null) {
            commandMetaData = new CommandMetaData(this.getEntityDefinition());
            commandMetaData.setCommand(this.commandBuilder.buildDeleteObjectCommand(this.getEntityDefinition()));
            this.putCommandMetaData(name, commandMetaData);
        }
        String sqlCommand = commandMetaData.getCommand();
        FieldNavigator ii = new FieldNavigator();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = conn.prepareStatement(sqlCommand);
            if (commandMetaData.getObjectMetaData() == null) {
                commandMetaData.setPropertyDescriptors(this.createPropertyDescriptorsForClass(obj.getClass(), null, null), null);
            }
            this.writeUpdateParameter(preparedStatement, ii, obj, commandMetaData);
            int res = preparedStatement.executeUpdate();
            if (res == 0) {
                throw this.exceptionFactory.createConflictException("Record could not be deleted (maybe somebody else updated or deleted it meanwhile)");
            }
        }
        catch (Exception e) {
            System.out.println(sqlCommand);
            throw new RuntimeException("Can not insert record in table " + this.getEntityDefinition().getName(), e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    protected void delete(String criteriaString, Object ... criterias) {
        String name = "delete" + criteriaString;
        Connection conn = this.getConnection();
        CommandMetaData commandMetaData = this.getCommandMetaData(name);
        if (commandMetaData == null) {
            commandMetaData = new CommandMetaData(this.getEntityDefinition());
            commandMetaData.setCommand(this.commandBuilder.buildDeleteWhereCommand(this.getEntityDefinition(), criteriaString));
            this.putCommandMetaData(name, commandMetaData);
        }
        String sqlCommand = commandMetaData.getCommand();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = conn.prepareStatement(sqlCommand);
            if (criteriaString != null) {
                for (int i = 0; i < criterias.length; ++i) {
                    this.setParameter(preparedStatement, i + 1, criterias[i]);
                }
            }
            preparedStatement.executeUpdate();
        }
        catch (Exception e) {
            System.out.println(sqlCommand);
            throw new RuntimeException("Can not read record from table " + this.getEntityDefinition().getName(), e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public <T> T load(Class<T> objectClass, Object ... key) {
        T obj = this.reflectionHelper.createObject(objectClass);
        this.load((CommandCustomizer)null, obj, key);
        return obj;
    }

    public <T> void load(T object, Object ... key) {
        this.load((CommandCustomizer)null, object, key);
    }

    protected <T> T load(CommandCustomizer statementAdapter, Class<T> objectClass, Object ... key) {
        T obj = this.reflectionHelper.createObject(objectClass);
        this.load(statementAdapter, obj, key);
        return obj;
    }

    protected <T> void load(CommandCustomizer statementAdapter, T obj, Object ... key) {
        if (obj == null) {
            throw new IllegalArgumentException("Object to be loaded into must not be null");
        }
        Class<?> objectClass = obj.getClass();
        String name = "load" + objectClass.getSimpleName() + statementAdapter;
        Connection conn = this.getConnection();
        CommandMetaData commandMetaData = this.getCommandMetaData(name);
        if (commandMetaData == null) {
            commandMetaData = new CommandMetaData(this.getEntityDefinition());
            commandMetaData.setCommand(this.commandBuilder.buildLoadCommand(this.getEntityDefinition(), objectClass, statementAdapter));
            this.putCommandMetaData(name, commandMetaData);
        }
        String sqlCommand = commandMetaData.getCommand();
        FieldNavigator ii = new FieldNavigator();
        PreparedStatement preparedStatement = null;
        RuntimeException notFoundException = null;
        try {
            preparedStatement = conn.prepareStatement(sqlCommand);
            for (int i = 0; i < key.length; ++i) {
                this.setParameter(preparedStatement, i + 1, key[i]);
            }
            ResultSet rs = preparedStatement.executeQuery();
            if (commandMetaData.getObjectMetaData() == null) {
                commandMetaData.setPropertyDescriptors(this.createPropertyDescriptorsForClass(objectClass, statementAdapter, rs), statementAdapter);
            }
            if (rs.next()) {
                ii.reset();
                this.readFieldsFromResultSet(obj, commandMetaData.getObjectMetaData(), rs, ii);
                if (statementAdapter != null) {
                    statementAdapter.customReadResultSet(rs, ii, obj);
                }
                return;
            }
            try {
                notFoundException = new RuntimeException("Object to load not found");
                throw notFoundException;
            }
            catch (Exception e) {
                System.out.println(sqlCommand);
                if (e == notFoundException) {
                    throw this.exceptionFactory.createNotFoundException("Object not found in table " + this.getEntityDefinition().getName());
                }
                throw new RuntimeException("Can not read record from table " + this.getEntityDefinition().getName(), e);
            }
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public <T> Collection<T> findAll(Class<T> objectClass) {
        return this.find(objectClass, null, null, new Object[0]);
    }

    public <T> Collection<T> find(Class<T> objectClass, String criteriaString, String orderByString, Object ... criterias) {
        return this.findWithPaging(objectClass, criteriaString, orderByString, 0, 0, criterias);
    }

    public <T> Collection<T> findWithPaging(Class<T> objectClass, String criteriaString, String orderByString, int page, int pageSize, Object ... criterias) {
        CommandMetaData commandMetaData;
        String name = "find" + objectClass.getSimpleName() + criteriaString + orderByString;
        if (page != 0) {
            name = name + "_paging";
        }
        if ((commandMetaData = this.getCommandMetaData(name)) == null) {
            commandMetaData = new CommandMetaData(this.getEntityDefinition());
            commandMetaData.setCommand(this.commandBuilder.buildFindCommand(this.getEntityDefinition(), objectClass, null, criteriaString, orderByString, page != 0));
            this.putCommandMetaData(name, commandMetaData);
        }
        String sqlCommand = commandMetaData.getCommand();
        FieldNavigator ii = new FieldNavigator();
        Connection conn = this.getConnection();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = conn.prepareStatement(sqlCommand);
            if (criteriaString != null) {
                for (int i = 0; i < criterias.length; ++i) {
                    this.setParameter(preparedStatement, i + 1, criterias[i]);
                }
            }
            if (page != 0) {
                int parameterLength = criterias.length;
                this.setParameter(preparedStatement, parameterLength + 1, (page - 1) * pageSize);
                this.setParameter(preparedStatement, parameterLength + 2, pageSize);
            }
            ResultSet rs = preparedStatement.executeQuery();
            if (commandMetaData.getObjectMetaData() == null) {
                commandMetaData.setPropertyDescriptors(this.createPropertyDescriptorsForClass(objectClass, null, rs), null);
            }
            ArrayList<T> resultList = new ArrayList<T>();
            while (rs.next()) {
                ii.reset();
                T obj = this.reflectionHelper.createObject(objectClass);
                this.readFieldsFromResultSet(obj, commandMetaData.getObjectMetaData(), rs, ii);
                resultList.add(obj);
            }
            ArrayList<T> arrayList = resultList;
            return arrayList;
        }
        catch (Exception e) {
            System.out.println(sqlCommand);
            throw new RuntimeException("Can not read record from table " + this.getEntityDefinition().getName(), e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    protected <T> Collection<T> select(Class<T> objectClass, String selectSQL, Object ... parameters) {
        String name = "select" + objectClass.getSimpleName() + selectSQL;
        CommandMetaData commandMetaData = this.getCommandMetaData(name);
        if (commandMetaData == null) {
            commandMetaData = new CommandMetaData(this.getEntityDefinition());
            commandMetaData.setCommand(selectSQL);
            this.putCommandMetaData(name, commandMetaData);
        }
        FieldNavigator ii = new FieldNavigator();
        Connection conn = this.getConnection();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = conn.prepareStatement(selectSQL.toString());
            for (int i = 0; i < parameters.length; ++i) {
                this.setParameter(preparedStatement, i + 1, parameters[i]);
            }
            ResultSet rs = preparedStatement.executeQuery();
            if (commandMetaData.getObjectMetaData() == null) {
                commandMetaData.setPropertyDescriptors(this.createPropertyDescriptorsForClass(objectClass, null, rs), null);
            }
            ArrayList<T> resultList = new ArrayList<T>();
            while (rs.next()) {
                ii.reset();
                T obj = this.reflectionHelper.createObject(objectClass);
                this.readFieldsFromResultSet(obj, commandMetaData.getObjectMetaData(), rs, ii);
                resultList.add(obj);
            }
            ArrayList<T> arrayList = resultList;
            return arrayList;
        }
        catch (Exception e) {
            System.out.println(selectSQL);
            throw new RuntimeException("Can not read record from table " + this.getEntityDefinition().getName(), e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    protected <T> Collection<T> selectWithPaging(Class<T> objectClass, String insertTableSQL, int page, int pageSize, Object ... parameters) {
        if (page > 0 && pageSize > 0) {
            int parameterLength = parameters.length;
            List<Object> paramterList = Arrays.asList(parameters);
            Object[] parametersWithPaging = paramterList.toArray(new Object[parameterLength + 2]);
            parametersWithPaging[parameterLength] = (page - 1) * pageSize;
            parametersWithPaging[parameterLength + 1] = pageSize;
            return this.select(objectClass, insertTableSQL + " OFFSET ? LIMIT ? ", parametersWithPaging);
        }
        return this.select(objectClass, insertTableSQL, parameters);
    }

    protected <T> PropertyDescriptor[] createPropertyDescriptorsForClass(Class<T> objectClass, CommandCustomizer statementAdapter, ResultSet rs) throws Exception {
        Field[] objectClassFields = this.reflectionHelper.getAllFields(objectClass);
        ArrayList<PropertyDescriptor> fieldList = new ArrayList<PropertyDescriptor>();
        if (rs != null) {
            ResultSetMetaData metaData = rs.getMetaData();
            for (int i = 0; i < metaData.getColumnCount(); ++i) {
                String recordFieldName = metaData.getColumnLabel(i + 1);
                String tableName = metaData.getTableName(i + 1);
                String propertyName = this.getEntityDefinition().fieldNameForColumn(recordFieldName, tableName);
                Field recordField = this.getEntityDefinition().findField(objectClassFields, propertyName);
                if (recordField == null) {
                    boolean isAdditionalColumn = false;
                    if (statementAdapter != null) {
                        for (String cn : statementAdapter.customColumns()) {
                            if (!recordFieldName.equalsIgnoreCase(cn)) continue;
                            isAdditionalColumn = true;
                            break;
                        }
                    }
                    if (!isAdditionalColumn) {
                        throw new RuntimeException("Property not found in bean '" + objectClass.getName() + "'. Expected property for field '" + recordFieldName + "' is '" + propertyName + "'");
                    }
                }
                if (recordField == null) continue;
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor(recordField.getName(), objectClass);
                fieldList.add(propertyDescriptor);
            }
        } else {
            for (EntityFieldDefinition dbField : this.getEntityDefinition().getFields()) {
                String recordFieldName = dbField.getName();
                String tableName = this.getEntityDefinition().getName();
                String propertyName = this.getEntityDefinition().fieldNameForColumn(recordFieldName, tableName);
                Field recordField = this.getEntityDefinition().findField(objectClassFields, propertyName);
                if (recordField == null) continue;
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor(propertyName, objectClass);
                fieldList.add(propertyDescriptor);
            }
        }
        PropertyDescriptor[] resultSetFields = new PropertyDescriptor[fieldList.size()];
        fieldList.toArray(resultSetFields);
        return resultSetFields;
    }

    public class CommandCustomizer {
        public String[] customColumns() {
            return null;
        }

        public void customSetStatementParameter(PreparedStatement preparedStatement, FieldNavigator ii, Object obj) throws Exception {
        }

        public void customReadResultSet(ResultSet rs, FieldNavigator ii, Object object) throws Exception {
        }
    }
}

