/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.provenience;

import java.lang.reflect.Constructor;
import java.util.Stack;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.iworkz.provenience.Initializeable;
import org.iworkz.provenience.Injector;

public class Provider<T> {
    protected final Class<T> injectedClass;
    protected Class<? extends T> implementationClass;
    protected boolean singleton;
    protected T instance;

    public Provider(T instance) {
        this(instance.getClass(), instance.getClass(), instance);
    }

    public Provider(Class<T> injectedClass, Class<? extends T> implementationClass, Object instance) {
        this.injectedClass = injectedClass;
        this.instance = instance;
        this.implementationClass = instance != null ? instance.getClass() : implementationClass;
        if (implementationClass != null) {
            this.singleton = implementationClass.isAnnotationPresent(Singleton.class);
        }
    }

    public Object getInstance(Injector injector, Stack<Class<?>> creationStack) {
        if (this.instance != null) {
            return this.instance;
        }
        creationStack.push(this.injectedClass);
        T newInstance = this.createInstance(injector, creationStack);
        if (this.singleton) {
            this.instance = newInstance;
        }
        creationStack.pop();
        injector.injectMembers(newInstance, newInstance.getClass(), creationStack);
        if (newInstance instanceof Initializeable) {
            Initializeable inititializeable = (Initializeable)newInstance;
            inititializeable.initialize();
        }
        return newInstance;
    }

    public T createInstance(Injector injector, Stack<Class<?>> creationStack) {
        if (this.implementationClass == null) {
            throw new IllegalArgumentException("The implementation class must be defined");
        }
        try {
            Constructor<T> constructor = this.getConstructor(this.implementationClass);
            if (constructor != null) {
                constructor.setAccessible(true);
                if (constructor.getParameterCount() > 0) {
                    Class<?>[] parameterTypes = constructor.getParameterTypes();
                    Object[] initargs = new Object[parameterTypes.length];
                    for (int i = 0; i < parameterTypes.length; ++i) {
                        initargs[i] = injector.get(parameterTypes[i], creationStack);
                    }
                    return constructor.newInstance(initargs);
                }
                return constructor.newInstance(new Object[0]);
            }
            throw new RuntimeException("No suitable constructor found for injection");
        }
        catch (Exception e) {
            throw new RuntimeException("Can not create singleton for class '" + this.implementationClass.getCanonicalName() + "'", e);
        }
    }

    public Constructor<? extends T> getConstructor(Class<? extends T> implementationClass) {
        Constructor<?> d = null;
        for (Constructor<?> c : implementationClass.getDeclaredConstructors()) {
            if (c.isAnnotationPresent(Inject.class)) {
                return c;
            }
            if (c.getParameterCount() != 0) continue;
            d = c;
        }
        return d;
    }
}

