package org.iworkz.provenience;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;

public class Binding<T> {

	protected final Class<T> singletonClass;
	protected Class<? extends T> implementationClass;
	protected T instance;
	protected Map<Annotation,Binding<T>> annotationBindings;
	protected Map<Class<? extends Annotation>,Binding<T>> annotationClassBindings;
	
	public Binding(Class<T> singletonClass) {
		this.singletonClass = singletonClass;
	}
	
	public Binding<T> annotatedWith(Annotation annotation) {
		if (annotationBindings == null) {
			annotationBindings = new HashMap<>();
		}
		Binding<T> annotationBinding = annotationBindings.get(annotation);
		if (annotationBinding == null) {
			annotationBinding = new Binding<T>(singletonClass);
			annotationBindings.put(annotation, annotationBinding);
		}
		return annotationBinding;
	}
	
	public Binding<T> annotatedWith(Class<? extends Annotation> annotationClass) {
		if (annotationClassBindings == null) {
			annotationClassBindings = new HashMap<>();
		}
		Binding<T> annotationClassBinding = annotationClassBindings.get(annotationClass);
		if (annotationClassBinding == null) {
			annotationClassBinding = new Binding<T>(singletonClass);
			annotationClassBindings.put(annotationClass, annotationClassBinding);
		}
		return annotationClassBinding;
	}

	public Binding<T> to(Class<? extends T> implementationClass) {
		this.implementationClass = implementationClass;
		instance = null;
		return this;
	}

	public void toInstance(T instance) {
		this.instance = instance;
		implementationClass = null;
	}

	public T getInstance() {
		return instance;
	}

}
