package org.iworkz.provenience;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class InjectionContext {
	
	final protected Stack<Class<?>> creationStack = new Stack<Class<?>>();
	final protected Map<Object,Set<Object>> createdInstances = new IdentityHashMap<>();
	
	public void putInjectedObject(Object instance, Object injectedObject) {
		Set<Object> injectedObjects = createdInstances.get(instance);
		if (injectedObjects == null) {
			injectedObjects = new HashSet<>();
			createdInstances.put(instance,injectedObjects);
		}
		injectedObjects.add(injectedObject);
	}
	
	public void putInjectedObjects(Object instance, Object[] injectedObjectArray) {
		if (injectedObjectArray != null && injectedObjectArray.length > 0) {
			Set<Object> injectedObjects = createdInstances.get(instance);
			if (injectedObjects == null) {
				injectedObjects = new HashSet<>();
				createdInstances.put(instance,injectedObjects);
			}
			for (Object injectedObject : injectedObjectArray) {
				injectedObjects.add(injectedObject);
			}
		}
	}

}
