package org.iworkz.provenience;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Module {
	
	private Map<Class<?>,Binding<?>> bindings;
	
	protected void configure() {
	}

	@SuppressWarnings("unchecked")
	protected <T> Binding<T> bind(Class<T> singletonClass) {
		if (bindings == null) {
			bindings = new HashMap<Class<?>,Binding<?>>();
		}
		
		Binding<T> binding = (Binding<T>)bindings.get(singletonClass);
		if (binding == null) {
			binding = new Binding<T>(singletonClass);
			bindings.put(singletonClass, binding);
		}
		return binding;
	}

	public Map<Class<?>, Binding<?>> getBindings() {
		return bindings;
	}
	
	public void postProcess(Map<Object,Set<Object>> createdInstances) {
		if (createdInstances != null) {
			for (Object instance : createdInstances.keySet()) {
				postProcess(instance,createdInstances.get(instance));
			}
		}
	}

	protected void postProcess(Object instance, Set<Object> injectedObjects) {
	}

}
