package org.iworkz.provenience;

import java.io.Serializable;
import java.lang.annotation.Annotation;

import javax.inject.Named;

public class Names {
	
	public static Named named(String name) {
		return new NamedImpl(name);
	}
	
	public static class NamedImpl implements Named, Serializable {
		
		private static final long serialVersionUID = 0;
		
		protected final String value;
		
		public NamedImpl(String value) {
			this.value = value;
		}
		
		@Override
		public Class<? extends Annotation> annotationType() {
			return Named.class;
		}

		@Override
		public String value() {
			return value;
		}

		public int hashCode() {
			// This is specified in java.lang.Annotation.
			return (127 * "value".hashCode()) ^ value.hashCode();
		}

		public boolean equals(Object o) {
			if (!(o instanceof Named)) {
				return false;
			}
			return value.equals(((Named)o).value());
		}
		
	}

}
