package org.iworkz.provenience;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.Map;

import javax.inject.Inject;
import javax.inject.Singleton;

public class Provider<T> {
	
	final protected Class<T> injectedClass;
	protected Class<? extends T> implementationClass;
	protected boolean singleton;
	protected T instance;
	protected Map<Annotation,Provider<T>> annotationProviders;
	protected Map<Class<? extends Annotation>,Provider<T>> annotationClassProviders;
	
	@SuppressWarnings("unchecked")
	public Provider(T instance) {
		this((Class<T>)instance.getClass(),(Class<? extends T>)instance.getClass(),instance);
	}
	
	@SuppressWarnings("unchecked")
	public Provider(Class<T> injectedClass, Class<? extends T> implementationClass, Object instance) {
		this.injectedClass = injectedClass;
		this.instance = (T)instance;
		if (instance != null) {
			this.implementationClass = (Class<? extends T>)instance.getClass();
		} else if (implementationClass != null) {
			this.implementationClass = implementationClass;
		} else {
			this.implementationClass = injectedClass;
		}
		if (this.implementationClass != null) {
			singleton = this.implementationClass.isAnnotationPresent(Singleton.class);
		}
	}
	
	public Object getInstance(Injector injector, Annotation annotation, InjectionContext ctx) {
		if (annotation != null) {
			if (annotationProviders != null) {
				Provider<T> annotationProvider= annotationProviders.get(annotation);
				if (annotationProvider != null) {
					return annotationProvider.getInstance(injector, null, ctx);
				}
			}
			if (annotationClassProviders != null) {
				Provider<T> annotationClassProvider= annotationClassProviders.get(annotation.annotationType());
				if (annotationClassProvider != null) {
					return annotationClassProvider.getInstance(injector, null, ctx);
				}
			}
		}
		if (instance != null) {
			return instance;
		}
		ctx.creationStack.push(injectedClass);
		T newInstance = (T)createInstance(injector,ctx);
		if (singleton) {
			instance = newInstance;
		}
		ctx.creationStack.pop();
		injector.injectMembers(newInstance,newInstance.getClass(),ctx);
		return newInstance;
	}

	public T createInstance(Injector injector, InjectionContext ctx) {
		if (implementationClass == null) {
			implementationClass = injectedClass;
//			throw new IllegalArgumentException("The implementation class must be defined");
		}
		try {
			Constructor<? extends T> constructor = getConstructor(implementationClass);
			if (constructor != null) {
				constructor.setAccessible(true);
				if (constructor.getParameterCount() > 0) {
					Parameter[] parameters = constructor.getParameters();
					Object[] initargs = new Object[parameters.length];
					for (int i=0;i<parameters.length;i++) {
						Parameter parameter = parameters[i];
						initargs[i] = injector.get(parameter.getType(),parameter,ctx);
					}
					T t = constructor.newInstance(initargs);
					ctx.putInjectedObjects(t, initargs);
					return t;
				} else {
					T t = constructor.newInstance();
					ctx.createdInstances.put(t, null);
					return t;
				}
			} else {
				throw new RuntimeException("No suitable constructor found for injection");
			}
		} catch (Exception e) {
			throw new RuntimeException("Can not create singleton for class '"+implementationClass.getCanonicalName()+"'",e);
		}
	}
	
	@SuppressWarnings("unchecked")
	public Constructor<? extends T> getConstructor(Class<? extends T> implementationClass) {
		Constructor<?> d = null;
		for (Constructor<?> c : implementationClass.getDeclaredConstructors()) {
			if (c.isAnnotationPresent(Inject.class)) {
				return (Constructor<? extends T>) c;
			}
			if (c.getParameterCount() == 0) {
				d = c;
			}
		}
		return (Constructor<? extends T>) d;
	}

}
