/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.terrain;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.j3d.terrain.AbstractTerrainData;
import org.j3d.terrain.TextureTileGenerator;
import org.j3d.terrain.TiledTerrainData;

public abstract class AbstractTiledTerrainData
extends AbstractTerrainData
implements TiledTerrainData {
    protected TextureTileGenerator tileGenerator;
    protected int gridPointsPerTile;
    private int widthPixelsPerGridStep;
    private int depthPixelsPerGridStep;
    private Rectangle pixelBounds;

    protected AbstractTiledTerrainData() {
        super(2);
        this.colorAvailable = false;
        this.textureAvailable = false;
    }

    @Override
    public int getTileSize() {
        return this.gridPointsPerTile;
    }

    @Override
    public BufferedImage getTexture(int tileX, int tileY) {
        BufferedImage ret_val = null;
        if (this.tileGenerator != null) {
            int x_grid = this.convertTileToGridCoord(tileX += 2);
            int y_grid = this.convertTileToGridCoord(++tileY);
            this.pixelBounds.x = x_grid * this.widthPixelsPerGridStep;
            this.pixelBounds.y = y_grid * this.depthPixelsPerGridStep;
            ret_val = this.tileGenerator.getTextureTile(this.pixelBounds);
            this.textureAvailable = true;
        }
        return ret_val;
    }

    public void setTextureTileGenerator(TextureTileGenerator gen) {
        this.tileGenerator = gen;
        if (gen != null) {
            if (this.pixelBounds == null) {
                this.pixelBounds = new Rectangle();
            }
            Dimension tex_size = gen.getTextureSize();
            this.widthPixelsPerGridStep = tex_size.width / this.gridPointsPerTile;
            this.depthPixelsPerGridStep = tex_size.height / this.gridPointsPerTile;
            this.pixelBounds.width = tex_size.width;
            this.pixelBounds.height = tex_size.height;
        }
    }

    protected int convertTileToGridCoord(int tile) {
        return tile * this.gridPointsPerTile;
    }

    protected int convertGridToTileCoord(int grid) {
        return grid / this.gridPointsPerTile;
    }
}

