/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.terrain.roam;

import java.util.LinkedList;
import org.j3d.maths.vector.Point3d;
import org.j3d.terrain.TerrainData;
import org.j3d.terrain.roam.QueueItem;
import org.j3d.terrain.roam.QueueManager;
import org.j3d.terrain.roam.VarianceTree;
import org.j3d.terrain.roam.VertexData;
import org.j3d.util.frustum.ViewFrustum;

public class TreeNode
extends QueueItem {
    public static final int UNDEFINED = -1;
    public static final int BASE_TO_BASE = 1;
    public static final int LEFT_TO_RIGHT = 2;
    public static final int RIGHT_TO_LEFT = 3;
    TreeNode leftChild;
    TreeNode rightChild;
    TreeNode baseNeighbour;
    TreeNode leftNeighbour;
    TreeNode rightNeighbour;
    TreeNode parent;
    private int leftX;
    private int leftY;
    private int rightX;
    private int rightY;
    private int apexX;
    private int apexY;
    private int node;
    private int depth;
    int visible = -1;
    private float p1X;
    private float p1Y;
    private float p1Z;
    private float p2X;
    private float p2Y;
    private float p2Z;
    private float p3X;
    private float p3Y;
    private float p3Z;
    private float p1tS;
    private float p1tT;
    private float p2tS;
    private float p2tT;
    private float p3tS;
    private float p3tT;
    private float p1R;
    private float p1G;
    private float p1B;
    private float p2R;
    private float p2G;
    private float p2B;
    private float p3R;
    private float p3G;
    private float p3B;
    private TerrainData terrainData;
    private VarianceTree varianceTree;
    boolean diamond = false;
    private boolean textured;
    private int patchX;
    private int patchY;
    private static LinkedList nodeCache = new LinkedList();

    private TreeNode() {
    }

    public int getVisibility() {
        return this.visible;
    }

    void newNode(int leftX, int leftY, int rightX, int rightY, int apexX, int apexY, int node, TerrainData terrainData, ViewFrustum frustum, int parentVisible, int depth, VarianceTree varianceTree, int patchX, int patchY) {
        this.leftX = leftX;
        this.leftY = leftY;
        this.rightX = rightX;
        this.rightY = rightY;
        this.apexX = apexX;
        this.apexY = apexY;
        this.node = node;
        this.terrainData = terrainData;
        this.depth = depth;
        this.varianceTree = varianceTree;
        this.patchX = patchX;
        this.patchY = patchY;
        this.init(frustum, parentVisible);
    }

    boolean isLeaf() {
        return this.leftChild == null;
    }

    void reset(ViewFrustum frustum) {
        if (this.leftChild != null) {
            this.leftChild.freeNode();
            this.leftChild = null;
        }
        if (this.rightChild != null) {
            this.rightChild.freeNode();
            this.rightChild = null;
        }
        this.baseNeighbour = null;
        this.leftNeighbour = null;
        this.rightNeighbour = null;
        this.visible = this.checkVisibility(frustum);
    }

    void freeNode() {
        if (this.leftChild != null) {
            this.leftChild.freeNode();
            this.leftChild = null;
        }
        if (this.rightChild != null) {
            this.rightChild.freeNode();
            this.rightChild = null;
        }
        this.baseNeighbour = null;
        this.leftNeighbour = null;
        this.rightNeighbour = null;
        this.parent = null;
        this.diamond = false;
        this.visible = -1;
        nodeCache.add(this);
    }

    void computeVariance(Point3d position) {
        float center_x = (this.p1X + this.p2X) * 0.5f;
        float center_z = -(this.p1Y + this.p2Y) * 0.5f;
        double pos_x = (position.x - (double)center_x) * (position.x - (double)center_x);
        double pos_z = (position.z - (double)center_z) * (position.z - (double)center_z);
        float distance = (float)Math.sqrt(pos_x + pos_z);
        float angle = (float)this.varianceTree.getVariance(this.node) / distance;
        this.variance = (float)Math.abs(Math.atan(angle));
    }

    int edgeSplit(TreeNode newNeighbour, int orientation, Point3d position, ViewFrustum frustum, QueueManager queue) {
        if (newNeighbour.leftChild == null) {
            return 0;
        }
        int tri_count = 0;
        if (this.leftChild == null) {
            this.forceSplit(position, frustum, queue);
            tri_count = 2;
        }
        switch (orientation) {
            case 2: {
                tri_count += this.rightChild.edgeSplit(newNeighbour.leftChild, 1, position, frustum, queue);
                break;
            }
            case 3: {
                tri_count += this.leftChild.edgeSplit(newNeighbour.rightChild, 1, position, frustum, queue);
                break;
            }
            case 1: {
                tri_count += this.rightChild.edgeSplit(newNeighbour.leftChild, 2, position, frustum, queue);
                tri_count += this.leftChild.edgeSplit(newNeighbour.rightChild, 3, position, frustum, queue);
            }
        }
        return tri_count;
    }

    void forceSplit(Point3d position, ViewFrustum frustum, QueueManager queue) {
        if (this.baseNeighbour != null) {
            if (this.baseNeighbour.baseNeighbour != this) {
                this.baseNeighbour.forceSplit(position, frustum, queue);
            }
            queue.removeTriangle(this);
            queue.removeTriangle(this.baseNeighbour);
            if (this.parent != null && this.isDiamond(this.parent)) {
                queue.removeDiamond(this.parent);
            }
            if (this.baseNeighbour.parent != null && this.isDiamond(this.baseNeighbour)) {
                queue.removeDiamond(this.baseNeighbour.parent);
            }
            this.split(position, frustum, queue);
            this.baseNeighbour.split(position, frustum, queue);
            this.leftChild.rightNeighbour = this.baseNeighbour.rightChild;
            this.rightChild.leftNeighbour = this.baseNeighbour.leftChild;
            this.baseNeighbour.leftChild.rightNeighbour = this.rightChild;
            this.baseNeighbour.rightChild.leftNeighbour = this.leftChild;
            queue.addTriangle(this.leftChild);
            queue.addTriangle(this.rightChild);
            queue.addTriangle(this.baseNeighbour.leftChild);
            queue.addTriangle(this.baseNeighbour.rightChild);
            queue.addDiamond(this);
        } else {
            if (this.parent != null && this.isDiamond(this.parent)) {
                queue.removeDiamond(this.parent);
            }
            queue.removeTriangle(this);
            this.split(position, frustum, queue);
            this.leftChild.rightNeighbour = null;
            this.rightChild.leftNeighbour = null;
            queue.addTriangle(this.leftChild);
            queue.addTriangle(this.rightChild);
        }
    }

    void split(Point3d position, ViewFrustum frustum, QueueManager queue) {
        this.initChildren(frustum);
        this.leftChild.leftNeighbour = this.rightChild;
        this.rightChild.rightNeighbour = this.leftChild;
        this.leftChild.baseNeighbour = this.leftNeighbour;
        if (this.leftNeighbour != null) {
            if (this.leftNeighbour.baseNeighbour == this) {
                this.leftNeighbour.baseNeighbour = this.leftChild;
            } else if (this.leftNeighbour.leftNeighbour == this) {
                this.leftNeighbour.leftNeighbour = this.leftChild;
            } else {
                this.leftNeighbour.rightNeighbour = this.leftChild;
            }
        }
        this.rightChild.baseNeighbour = this.rightNeighbour;
        if (this.rightNeighbour != null) {
            if (this.rightNeighbour.baseNeighbour == this) {
                this.rightNeighbour.baseNeighbour = this.rightChild;
            } else if (this.rightNeighbour.rightNeighbour == this) {
                this.rightNeighbour.rightNeighbour = this.rightChild;
            } else {
                this.rightNeighbour.leftNeighbour = this.rightChild;
            }
        }
        if (this.depth + 1 < this.varianceTree.getMaxDepth() && this.visible != 2) {
            this.rightChild.computeVariance(position);
            this.leftChild.computeVariance(position);
        }
    }

    int merge(QueueManager queue) {
        queue.removeDiamond(this);
        int num_tris = this.internalMerge(queue);
        num_tris += this.baseNeighbour.internalMerge(queue);
        if (this.parent != null && this.isDiamond(this.parent)) {
            queue.addDiamond(this.parent);
        }
        if (this.baseNeighbour.parent != null && this.isDiamond(this.baseNeighbour.parent)) {
            queue.addDiamond(this.baseNeighbour.parent);
        }
        queue.addTriangle(this);
        queue.addTriangle(this.baseNeighbour);
        return num_tris;
    }

    void getTriangles(VertexData vertexData) {
        if (this.leftChild == null) {
            if (this.visible != 2 && this.visible != -1) {
                switch (vertexData.dataType) {
                    case 1: {
                        vertexData.addVertex(this.p1X, this.p1Y, this.p1Z);
                        vertexData.addVertex(this.p2X, this.p2Y, this.p2Z);
                        vertexData.addVertex(this.p3X, this.p3Y, this.p3Z);
                        break;
                    }
                    case 2: {
                        vertexData.addVertex(this.p1X, this.p1Y, this.p1Z, this.p1R, this.p1G, this.p1B);
                        vertexData.addVertex(this.p2X, this.p2Y, this.p2Z, this.p2R, this.p2G, this.p2B);
                        vertexData.addVertex(this.p3X, this.p3Y, this.p3Z, this.p3R, this.p3G, this.p3B);
                        break;
                    }
                    case 3: {
                        vertexData.addVertex(this.p1X, this.p1Y, this.p1Z, this.p1tS, this.p1tT);
                        vertexData.addVertex(this.p2X, this.p2Y, this.p2Z, this.p2tS, this.p2tT);
                        vertexData.addVertex(this.p3X, this.p3Y, this.p3Z, this.p3tS, this.p3tT);
                        break;
                    }
                    case 4: {
                        vertexData.addVertex(this.p1X, this.p1Y, this.p1Z, this.p1R, this.p1G, this.p1B, this.p1tS, this.p1tT);
                        vertexData.addVertex(this.p2X, this.p2Y, this.p2Z, this.p2R, this.p2G, this.p2B, this.p2tS, this.p2tT);
                        vertexData.addVertex(this.p3X, this.p3Y, this.p3Z, this.p3R, this.p3G, this.p3B, this.p3tS, this.p3tT);
                    }
                }
            }
        } else {
            this.leftChild.getTriangles(vertexData);
            this.rightChild.getTriangles(vertexData);
        }
    }

    int checkVisibility(ViewFrustum frustum) {
        return frustum.isTriangleInFrustum(this.p1X, this.p1Y, this.p1Z, this.p2X, this.p2Y, this.p2Z, this.p3X, this.p3Y, this.p3Z);
    }

    void updateTree(Point3d position, ViewFrustum frustum, VarianceTree varianceTree, int parentVisible, QueueManager queue) {
        this.visible = parentVisible == -1 || parentVisible == 4 ? frustum.isTriangleInFrustum(this.p1X, this.p1Y, this.p1Z, this.p2X, this.p2Y, this.p2Z, this.p3X, this.p3Y, this.p3Z) : parentVisible;
        if (this.leftChild == null && this.rightChild == null && this.depth < varianceTree.getMaxDepth() && this.visible != 2) {
            this.computeVariance(position);
            queue.addTriangle(this);
        } else if (this.leftChild != null) {
            this.leftChild.updateTree(position, frustum, varianceTree, this.visible, queue);
            this.rightChild.updateTree(position, frustum, varianceTree, this.visible, queue);
        }
    }

    public static TreeNode getTreeNode() {
        TreeNode ret_val = nodeCache.size() > 0 ? (TreeNode)nodeCache.removeFirst() : new TreeNode();
        return ret_val;
    }

    private void init(ViewFrustum frustum, int parentVisible) {
        float[] tmp = new float[3];
        float[] tex = new float[2];
        float[] col = new float[3];
        int type = this.terrainData.hasTexture() ? 1 : 0;
        switch (type += this.terrainData.hasColor() ? 2 : 0) {
            case 0: {
                this.terrainData.getCoordinate(tmp, this.leftX, this.leftY);
                break;
            }
            case 1: {
                this.terrainData.getCoordinateWithTexture(tmp, tex, this.leftX, this.leftY, this.patchX, this.patchY);
                this.p1tS = tex[0];
                this.p1tT = tex[1];
                break;
            }
            case 2: {
                this.terrainData.getCoordinateWithColor(tmp, col, this.leftX, this.leftY);
                this.p1R = col[0];
                this.p1G = col[1];
                this.p1B = col[2];
                break;
            }
            case 3: {
                this.terrainData.getCoordinate(tmp, tex, col, this.leftX, this.leftY);
                this.p1tS = tex[0];
                this.p1tT = tex[1];
                this.p1R = col[0];
                this.p1G = col[1];
                this.p1B = col[2];
            }
        }
        this.p1X = tmp[0];
        this.p1Y = tmp[1];
        this.p1Z = tmp[2];
        switch (type) {
            case 0: {
                this.terrainData.getCoordinate(tmp, this.rightX, this.rightY);
                break;
            }
            case 1: {
                this.terrainData.getCoordinateWithTexture(tmp, tex, this.rightX, this.rightY, this.patchX, this.patchY);
                this.p2tS = tex[0];
                this.p2tT = tex[1];
                break;
            }
            case 2: {
                this.terrainData.getCoordinateWithColor(tmp, col, this.rightX, this.rightY);
                this.p2R = col[0];
                this.p2G = col[1];
                this.p2B = col[2];
                break;
            }
            case 3: {
                this.terrainData.getCoordinate(tmp, tex, col, this.rightX, this.rightY);
                this.p2tS = tex[0];
                this.p2tT = tex[1];
                this.p2R = col[0];
                this.p2G = col[1];
                this.p2B = col[2];
            }
        }
        this.p2X = tmp[0];
        this.p2Y = tmp[1];
        this.p2Z = tmp[2];
        switch (type) {
            case 0: {
                this.terrainData.getCoordinate(tmp, this.apexX, this.apexY);
                break;
            }
            case 1: {
                this.terrainData.getCoordinateWithTexture(tmp, tex, this.apexX, this.apexY, this.patchX, this.patchY);
                this.p3tS = tex[0];
                this.p3tT = tex[1];
                break;
            }
            case 2: {
                this.terrainData.getCoordinateWithColor(tmp, col, this.apexX, this.apexY);
                this.p3R = col[0];
                this.p3G = col[1];
                this.p3B = col[2];
                break;
            }
            case 3: {
                this.terrainData.getCoordinate(tmp, tex, col, this.apexX, this.apexY);
                this.p3tS = tex[0];
                this.p3tT = tex[1];
                this.p3R = col[0];
                this.p3G = col[1];
                this.p3B = col[2];
            }
        }
        this.p3X = tmp[0];
        this.p3Y = tmp[1];
        this.p3Z = tmp[2];
        this.visible = parentVisible == -1 || parentVisible == 4 ? frustum.isTriangleInFrustum(this.p1X, this.p1Y, this.p1Z, this.p2X, this.p2Y, this.p2Z, this.p3X, this.p3Y, this.p3Z) : parentVisible;
        this.variance = 0.0f;
    }

    private int internalMerge(QueueManager queue) {
        TreeNode new_left = this.leftChild.baseNeighbour;
        TreeNode new_right = this.rightChild.baseNeighbour;
        this.leftNeighbour = new_left;
        this.rightNeighbour = new_right;
        if (new_left != null) {
            if (new_left.baseNeighbour == this.leftChild) {
                new_left.baseNeighbour = this;
            } else if (new_left.leftNeighbour == this.leftChild) {
                new_left.leftNeighbour = this;
            } else {
                new_left.rightNeighbour = this;
            }
        }
        if (new_right != null) {
            if (new_right.baseNeighbour == this.rightChild) {
                new_right.baseNeighbour = this;
            } else if (new_right.rightNeighbour == this.rightChild) {
                new_right.rightNeighbour = this;
            } else {
                new_right.leftNeighbour = this;
            }
        }
        queue.removeTriangle(this.leftChild);
        queue.removeTriangle(this.rightChild);
        this.leftChild.freeNode();
        this.rightChild.freeNode();
        this.leftChild = null;
        this.rightChild = null;
        this.diamond = true;
        return 2;
    }

    private boolean isDiamond(TreeNode node) {
        return node.isDiamond() && node.baseNeighbour.isDiamond();
    }

    private boolean isDiamond() {
        this.diamond = this.baseNeighbour == null ? false : this.baseNeighbour.baseNeighbour == this && this.leftChild != null && this.baseNeighbour.leftChild != null && this.leftChild.leftChild == null && this.rightChild.leftChild == null && this.baseNeighbour.leftChild.leftChild == null && this.baseNeighbour.rightChild.leftChild == null;
        return this.diamond;
    }

    private void initChildren(ViewFrustum frustum) {
        int splitX = this.leftX + this.rightX >> 1;
        int splitY = this.leftY + this.rightY >> 1;
        this.leftChild = TreeNode.getTreeNode();
        this.rightChild = TreeNode.getTreeNode();
        this.leftChild.newNode(this.apexX, this.apexY, this.leftX, this.leftY, splitX, splitY, this.node << 1, this.terrainData, frustum, this.visible, this.depth + 1, this.varianceTree, this.patchX, this.patchY);
        this.rightChild.newNode(this.rightX, this.rightY, this.apexX, this.apexY, splitX, splitY, 1 + (this.node << 1), this.terrainData, frustum, this.visible, this.depth + 1, this.varianceTree, this.patchX, this.patchY);
        this.leftChild.parent = this;
        this.rightChild.parent = this;
    }
}

