/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.terrain.roam;

import java.util.TreeSet;
import org.j3d.terrain.roam.DiamondComparator;
import org.j3d.terrain.roam.QueueItem;
import org.j3d.terrain.roam.QueueManager;
import org.j3d.terrain.roam.TreeNode;
import org.j3d.terrain.roam.TriangleComparator;

class TreeQueueManager
implements QueueManager {
    private TreeSet triQueue = new TreeSet(new TriangleComparator());
    private TreeSet diamondQueue = new TreeSet(new DiamondComparator());

    @Override
    public void addTriangle(QueueItem node) {
        if (!(node instanceof TreeNode)) {
            throw new RuntimeException("Not a TreeNode");
        }
        this.triQueue.add(node);
    }

    @Override
    public void removeTriangle(QueueItem node) {
        if (!(node instanceof TreeNode)) {
            throw new RuntimeException("Not a TreeNode");
        }
        this.triQueue.remove(node);
    }

    @Override
    public void addDiamond(QueueItem node) {
        if (!(node instanceof TreeNode)) {
            throw new RuntimeException("Not a TreeNode");
        }
        this.diamondQueue.add(node);
    }

    @Override
    public void removeDiamond(QueueItem node) {
        if (!(node instanceof TreeNode)) {
            throw new RuntimeException("Not a TreeNode");
        }
        this.diamondQueue.remove(node);
    }

    @Override
    public void clear() {
        this.triQueue.clear();
        this.diamondQueue.clear();
    }

    public TreeNode getSplitCandidate() {
        TreeNode ret_val = null;
        if (!this.triQueue.isEmpty()) {
            ret_val = (TreeNode)this.triQueue.last();
        }
        return ret_val;
    }

    public TreeNode getMergeCandidate() {
        TreeNode ret_val = null;
        if (!this.diamondQueue.isEmpty()) {
            ret_val = (TreeNode)this.diamondQueue.first();
        }
        return ret_val;
    }
}

