/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.terrain.roam;

public class VertexData {
    static final byte COORD_ONLY = 1;
    static final byte COLOR_ONLY = 2;
    static final byte TEXTURE_ONLY = 3;
    static final byte TEXTURE_AND_COLOR = 4;
    final byte dataType;
    private float[] coords;
    private byte[] colors;
    private float[] textureCoords;
    private int index;
    private int texIndex;

    public VertexData(int patchSize, boolean hasTexture, boolean hasColor) {
        this.coords = new float[patchSize * patchSize * 2 * 3 * 3];
        if (hasTexture) {
            this.textureCoords = new float[patchSize * patchSize * 2 * 3 * 2];
        }
        if (hasColor) {
            this.colors = new byte[this.coords.length];
        }
        int type = 1;
        type = (byte)(type + (hasColor ? 1 : 0));
        type = (byte)(type + (hasTexture ? 2 : 0));
        this.dataType = (byte)type;
    }

    public float[] getCoords() {
        return this.coords;
    }

    public byte[] getColors() {
        return this.colors;
    }

    public float[] getTextureCoords() {
        return this.textureCoords;
    }

    void addVertex(float x, float y, float z) {
        this.coords[this.index] = x;
        this.coords[this.index + 1] = y;
        this.coords[this.index + 2] = z;
        this.index += 3;
    }

    void addVertex(float x, float y, float z, byte clrR, byte clrG, byte clrB) {
        this.coords[this.index] = x;
        this.coords[this.index + 1] = y;
        this.coords[this.index + 2] = z;
        if (this.dataType != 2 && this.dataType != 4) {
            System.out.println("Setting color on a uncolored object");
        } else {
            this.colors[this.index] = clrR;
            this.colors[this.index + 1] = clrG;
            this.colors[this.index + 2] = clrB;
        }
        this.index += 3;
    }

    void addVertex(float x, float y, float z, float r, float g, float b) {
        byte r_tmp = (byte)(r * 255.0f);
        byte g_tmp = (byte)(g * 255.0f);
        byte b_tmp = (byte)(b * 255.0f);
        this.addVertex(x, y, z, r_tmp, g_tmp, b_tmp);
    }

    void addVertex(float x, float y, float z, float texS, float texT) {
        this.coords[this.index] = x;
        this.coords[this.index + 1] = y;
        this.coords[this.index + 2] = z;
        if (this.dataType != 3 && this.dataType != 4) {
            System.out.println("Setting texture coords in untextured object");
        } else {
            this.textureCoords[this.texIndex++] = texS;
            this.textureCoords[this.texIndex++] = texT;
        }
        this.index += 3;
    }

    void addVertex(float x, float y, float z, byte clrR, byte clrG, byte clrB, float texS, float texT) {
        this.coords[this.index] = x;
        this.coords[this.index + 1] = y;
        this.coords[this.index + 2] = z;
        if (this.dataType != 2 && this.dataType != 4) {
            System.out.println("Setting color on a uncolored object");
        } else {
            this.colors[this.index] = clrR;
            this.colors[this.index + 1] = clrG;
            this.colors[this.index + 2] = clrB;
        }
        this.index += 3;
        if (this.dataType != 3 && this.dataType != 4) {
            System.out.println("Setting texture coords in untextured object");
        } else {
            this.textureCoords[this.texIndex++] = texS;
            this.textureCoords[this.texIndex++] = texT;
        }
    }

    void addVertex(float x, float y, float z, float r, float g, float b, float texS, float texT) {
        byte r_tmp = (byte)(r * 255.0f);
        byte g_tmp = (byte)(g * 255.0f);
        byte b_tmp = (byte)(b * 255.0f);
        this.addVertex(x, y, z, r_tmp, g_tmp, b_tmp, texS, texT);
    }

    public int getVertexCount() {
        return this.index / 3;
    }

    void reset() {
        this.index = 0;
        this.texIndex = 0;
    }
}

